% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_club.R
\name{get_club}
\alias{get_club}
\title{Get club data}
\usage{
get_club(stoken, id = NULL, request = NULL)
}
\arguments{
\item{stoken}{A \code{\link[httr]{config}} object created using the \code{\link{strava_oauth}} function}

\item{id}{character vector for id of the club, defaults to authenticated club of the athlete}

\item{request}{chr string, must be "members", "activities" or \code{NULL} for club details}
}
\value{
Data from an API request.
}
\description{
Get club data for a given request
}
\details{
Requires authentication stoken using the \code{\link{strava_oauth}} function and a user-created API on the strava website.
}
\examples{
\dontrun{
# create authentication token
# requires user created app name, id, and secret from Strava website
stoken <- httr::config(token = strava_oauth(app_name, app_client_id, 
	app_secret, cache = TRUE))

get_club(stoken)
}
}
\concept{token}
