% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compile_activities.R
\name{compile_activities}
\alias{compile_activities}
\title{converts a list of activities into a dataframe}
\usage{
compile_activities(actlist, acts = NULL, id = NULL, units = "metric")
}
\arguments{
\item{actlist}{an activities list returned by \code{\link{get_activity_list}}}

\item{acts}{numeric indicating which activities to compile starting with most recent, defaults to all}

\item{id}{optional character vector to specify the id(s) of the activity/activities to plot, \code{acts} is ignored if provided}

\item{units}{chr string indicating metric or imperial}
}
\value{
An activities frame object (\code{actframe} that includes a data frame for the data and attributes for the distance, speed, and elevation units
}
\description{
converts a list of activities into a dataframe
}
\details{
each activity has a value for every column present across all activities, with NAs populating empty values
}
\examples{
 
\dontrun{
stoken <- httr::config(token = strava_oauth(app_name, app_client_id, app_secret, cache = TRUE))

my_acts <- get_activity_list(stoken)

acts_data <- compile_activities(my_acts)

# show attributes
attr(acts_data, 'unit_type')
attr(acts_data, 'unit_vals')
}
}
\seealso{
\code{\link{compile_club_activities}} for compiling an activities list for club activities
}
\author{
Daniel Padfield
}
\concept{token}
