% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrapperFunctions.R
\name{analyzeFolder}
\alias{analyzeFolder}
\title{Analysis of all corneal topography files in a folder}
\usage{
analyzeFolder(
  path,
  fileExtension = "txt",
  individualPlots = FALSE,
  summaryPlot = FALSE
)
}
\arguments{
\item{path}{The path of a folder which contains corneal topography files, as exported by Placido disks corneal topographers.}

\item{fileExtension}{The file extension of the corneal topography files in the folder ("txt" by default).}

\item{individualPlots}{An optional logical parameter (by default, FALSE) indicating whether the plot for each file should be displayed or not.}

\item{summaryPlot}{An optional logical parameter (by default, FALSE) indicating whether a summary plot should be displayed or not.}
}
\value{
A \code{data.frame} containing the Placido irregularity indices as well as the diagnose, with as many rows as data files in the folder, and columns:
\tabular{lll}{
  \code{Diagnose}   \tab\tab A text label indicating the diagnose, according to the value of GLPI\cr
  \code{NBI}   \tab\tab The value of NBI index (in the range 0-100).\cr
  \code{GLPI}  \tab\tab The value of GLPI index (in the range 0-100).\cr
  \code{PI_1}  \tab\tab The value of PI_1 index (usually in the range 0-150).\cr   
  \code{PI_2}  \tab\tab The value of PI_2 index (usually in the range 0-150).\cr   
  \code{PI_3}  \tab\tab The value of PI_3 index (usually in the range 0-150).\cr   
  \code{SL}  \tab\tab The value of SL index (usually in the range 0-150).\cr   
  \code{AR_1}  \tab\tab The value of AR_1 index (usually in the range 0-150).\cr
  \code{AR_2}  \tab\tab The value of AR_2 index (usually in the range 0-150).\cr   
  \code{AR_3}  \tab\tab The value of AR_3 index (usually in the range 0-150).\cr   
  \code{AR_4}  \tab\tab The value of AR_4 index (usually in the range 0-150).\cr   
  \code{AR_5}  \tab\tab The value of AR_5 index (usually in the range 0-150).\cr      
}
}
\description{
This function analyzes all corneal topography files that are stored in a common folder. It is 
equivalent to use \link[rPACI]{analyzeFile} on each file in the folder, and then binding the results.
}
\details{
This function assumes all files in the folder that have the extension given by the argument \code{fileExtension} 
("txt", by default) are corneal topography files and are to be processed. 
The result is a \code{data.frame} in the same format yield by \link[rPACI]{computePlacidoIndices} or \link[rPACI]{analyzeFile},
but with as many rows as matching files were found in the folder.

More details about supported file formats can be found in 
\href{../doc/topographersDataFormat.html}{\code{vignette("topographersDataFormat", package = "rPACI")}}, 
and about using \code{rPACI} in \href{../doc/packageUsage.html}{\code{vignette("packageUsage", package = "rPACI")}}.
}
\examples{
# This analyzes together all the corneal topography example files included in rPACI:
\dontrun{
analyzeFolder(system.file("extdata",package="rPACI"))
}
}
