% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pre_processing.R
\name{add_missingness}
\alias{add_missingness}
\title{Apply MAR missingness to data}
\usage{
add_missingness(X, prop, cols = NULL)
}
\arguments{
\item{X}{A data.frame or similar}

\item{prop}{Numeric value between 0 and 1; the proportion of observations set to missing}

\item{cols}{A vector of column names to be corrupted; if NULL, all columns are used}
}
\value{
Data with missing values
}
\description{
Helper function to add missing values to data.
}
\examples{
whole_data <- data.frame(a = rnorm(1000),
                        b = rnorm(1000))

missing_data <- add_missingness(whole_data, 0.1)
}
\keyword{preprocessing}
