% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rMEA_util.R
\name{timeMaster}
\alias{timeMaster}
\title{Transform time values between different formats}
\usage{
timeMaster(
  baseTime,
  add = 0,
  out = c("auto", "hour", "min", "sec"),
  baseSep = "[\\\\.,:,\\\\,',-,\\"]"
)
}
\arguments{
\item{baseTime, add}{either integer of seconds or a time string in the format h:m:s, m:s, or s, with or without leading zeroes}

\item{out}{a character string indicating the format of the output. One of "auto" (the default which tries to keep the format of \code{'baseTime'}), "hour", "min", or "sec": can be abbreviated.}

\item{baseSep}{a character string or a regular expression identifying separators in \code{baseTime}}
}
\description{
This function allows to
}
\examples{
## Adding seconds to minutes
timeMaster(30, add="10:00", out = "min")

## Adding strings to integer seconds and returning a numeric value
timeMaster(30, add="10:00")

## Automatic detection of format
timeMaster("01:30:55",add="10:00",out = "auto")
}
