% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rMEA_rand.R
\name{shuffle_segments}
\alias{shuffle_segments}
\title{Shuffle MEA data (within subjects)}
\usage{
shuffle_segments(mea, n_each, segSec)
}
\arguments{
\item{mea}{a list of \code{MEA} objects (see function \code{\link{readMEA}}).}

\item{n_each}{the number of random dyads to be generated from each real dyad.}

\item{segSec}{the width (in seconds) of the shuffling segments.}
}
\value{
an object of class \code{MEAlist} containing \code{n_each * length(mea)} random dyads.
}
\description{
This function generates fakes dyads to be used for pseudosynchrony calculations following the Ramseyer & Tschacher (2010)
within-subject segment shuffling approach.
Between subjects shuffling \code{\link{shuffle}} is probably more conservative, and suggested for most cases.
This function is provided for replicability of older studies, and can be useful to quickly assess pseudosynchrony in single sessions,
or very small samples.
}
\details{
For each \code{MEA} object, the shuffling procedure first divides s1 and s2 MEA data in segments of size \code{segSec},
then shuffles them within subject (so that the new segments of s1, are the old segments of s1 in a new order). This is repeated
for \code{n_each} times, before getting to the next \code{MEA} object

Note: all the ccf data, if present, are discarded from the shuffled objects and have to be calculated again using \code{\link{MEAccf}}
}
\examples{
## read the first 4 minutes of the normal sample
##   (intake interviews of patients that carried on therapy)
path_normal <- system.file("extdata/normal", package = "rMEA")
mea_normal <- readMEA(path_normal, sampRate = 25, s1Col = 1, s2Col = 2,
                     s1Name = "Patient", s2Name = "Therapist",
                     idOrder = c("id","session"), idSep="_", skip=1, nrow = 6000)
mea_normal <- setGroup(mea_normal, "normal")

## Create a shuffled sample
mea_rand = shuffle_segments(mea_normal, n_each=10, segSec=30)

summary(mea_rand)
}
