% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clipLevel2B.R
\name{clipLevel2B}
\alias{clipLevel2B}
\title{Clip GEDI Level2B data by Coordinates}
\usage{
clipLevel2B(level2b, xmin, xmax, ymin, ymax, output = "")
}
\arguments{
\item{level2b}{A GEDI Level2B object (output of \code{\link[rGEDI:readLevel2B]{readLevel2B}} function).
An S4 object of class "gedi.level2b".}

\item{xmin}{Numeric. West longitude (x) coordinate of the bounding rectangle, in decimal degrees.}

\item{xmax}{Numeric. East longitude (x) coordinate of the bounding rectangle, in decimal degrees.}

\item{ymin}{Numeric. South latitude (y) coordinate of the bounding rectangle, in decimal degrees.}

\item{ymax}{Numeric. North latitude (y) coordinate of the bounding rectangle, in decimal degrees.}

\item{output}{Optional character path where to save the new hdf5 file. The default stores a temporary file only.}
}
\value{
Returns a list of S4 object of class "gedi.level2b" containing clipped GEDI Level2B data.
}
\description{
This function extracts GEDI Level1B data a within given bounding coordinates
}
\examples{
\donttest{
outdir = tempdir()

# Specifying the path to GEDI level2B data (zip file)
level2B_fp_zip <- system.file("extdata",
                  "GEDI02_B_2019108080338_O01964_T05337_02_001_01_sub.zip",
                  package="rGEDI")

# Unzipping GEDI level2A data
level2Bpath <- unzip(level2B_fp_zip,exdir = outdir)

# Reading GEDI level2B data (h5 file)
level2b<-readLevel2B(level2Bpath=level2Bpath)

# Bounding rectangle coordinates
xmin=-44.13
xmax=-44.12
ymin=-13.74
ymax=-13.73

# Specifying output file and path
output<-file.path(outdir,"GEDI02_B_2019108080338_O01964_T05337_02_001_01_clip")

# Clipping GEDI data by extent boundary box
level2b_clip <- clipLevel2B(level2b, xmin, xmax, ymin, ymax)

close(level2b)
close(level2b_clip)
}
}
\seealso{
https://lpdaac.usgs.gov/products/gedi01_bv001/
}
