% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multiview_interface.R
\name{multiview}
\alias{multiview}
\title{Perform forecasting using multiview embedding}
\usage{
multiview(block, lib = c(1, floor(NROW(block)/2)),
  pred = c(floor(NROW(block)/2) + 1, NROW(block)), norm = 2, E = 3,
  tau = 1, tp = 1, max_lag = 3, num_neighbors = "e+1",
  k = "sqrt", na.rm = FALSE, target_column = 1, stats_only = TRUE,
  save_lagged_block = FALSE, first_column_time = FALSE,
  exclusion_radius = NULL, silent = FALSE)
}
\arguments{
\item{block}{either a vector to be used as the time series, or a 
data.frame or matrix where each column is a time series}

\item{lib}{a 2-column matrix (or 2-element vector) where each row specifies 
the first and last *rows* of the time series to use for attractor 
reconstruction}

\item{pred}{(same format as lib), but specifying the sections of the time 
series to forecast.}

\item{norm}{the distance measure to use. see 'Details'}

\item{E}{the embedding dimensions to use for time delay embedding}

\item{tau}{the lag to use for time delay embedding}

\item{tp}{the prediction horizon (how far ahead to forecast)}

\item{max_lag}{the maximum number of lags to use for variable combinations. 
So if max_lag == 3, a variable X will appear with lags X[t], X[t - tau], 
X[t - 2*tau]}

\item{num_neighbors}{the number of nearest neighbors to use. Note that the 
default value will change depending on the method selected. (any of "e+1", 
"E+1", "e + 1", "E + 1" will peg this parameter to E+1 for each run, any
value < 1 will use all possible neighbors.)}

\item{k}{the number of embeddings to use ("sqrt" will use k = floor(sqrt(m)), 
"all" or values less than 1 will use k = m)}

\item{na.rm}{logical. Should missing values (including `NaN`` be omitted 
from the calculations?)}

\item{target_column}{the index (or name) of the column to forecast}

\item{stats_only}{specify whether to output just the forecast statistics or 
the raw predictions for each run}

\item{save_lagged_block}{specify whether to output the lagged block that 
is constructed as part of running \code{multiview}}

\item{first_column_time}{indicates whether the first column of the given 
block is a time column (and therefore excluded when indexing)}

\item{exclusion_radius}{excludes vectors from the search space of nearest 
neighbors if their *time index* is within exclusion_radius (NULL turns 
this option off)}

\item{silent}{prevents warning messages from being printed to the R console}
}
\value{
A data.frame with components for the parameters and forecast 
  statistics:
\tabular{ll}{
  E \tab embedding dimension\cr
  tau \tab time lag\cr
  tp \tab prediction horizon\cr
  nn \tab number of neighbors\cr
  k \tab number of embeddings used\cr
}
\tabular{ll}{
  \code{E} \tab embedding dimension\cr
  \code{tau} \tab time lag\cr
  \code{tp} \tab prediction horizon\cr
  \code{nn} \tab number of neighbors\cr
  \code{k} \tab number of embeddings used\cr
  \code{num_pred} \tab number of predictions\cr
  \code{rho} \tab correlation coefficient between observations and 
    predictions\cr
  \code{mae} \tab mean absolute error\cr
  \code{rmse} \tab root mean square error\cr
  \code{perc} \tab percent correct sign\cr
  \code{p_val} \tab p-value that rho is significantly greater than 0 using 
    Fisher's z-transformation\cr
  \code{model_output} \tab data.frame with columns for the time index, 
    observations, predictions, and estimated prediction variance
    (if \code{stats_only == FALSE})\cr
  \code{embeddings} \tab list of the columns used in each of the embeddings 
    that comprise the model (if \code{stats_only == FALSE})\cr
}
}
\description{
\code{\link{multiview}} applies the method described in Ye & Sugihara (2016) for 
  forecasting, wherein multiple attractor reconstructions are tested, and a 
  single nearest neighbor is selected from each of the top \code{k} 
  reconstructions to produce final forecasts.
}
\details{
uses multiple time series given as input to generate an attractor 
  reconstruction, and then applies the simplex projection or s-map algorithm 
  to make forecasts. This method generalizes the \code{\link{simplex}} and 
  \code{\link{s_map}} routines, and allows for "mixed" embeddings, where multiple 
  time series can be used as different dimensions of an attractor 
  reconstruction.

The default parameters are set so that, given a matrix of time series, 
  forecasts will be produced for the first column. By default, all possible 
  combinations of the columns are used for the attractor construction, the 
  k = sqrt(m) heuristic will be used, forecasts will be one time step ahead. 
  Rownames will be converted to numeric if possible to be used as the time 
  index, otherwise 1:NROW will be used instead. The default lib and pred are 
  to use the first half of the data for the "library" and to predict over the
  second half of the data. Unless otherwise set, the output will be just the 
  forecast statistics.

\code{norm = 2} (default) uses the "L2 norm", Euclidean distance:
  \deqn{distance(a,b) := \sqrt{\sum_i{(a_i - b_i)^2}}
    }{distance(a, b) := \sqrt(\sum(a_i - b_i)^2)}
\code{norm = 1} uses the "L1 norm", Manhattan distance:
  \deqn{distance(a,b) := \sum_i{|a_i - b_i|}
    }{distance(a, b) := \sum|a_i - b_i|}
Other values generalize the L1 and L2 norm to use the given argument as the 
  exponent, P, as:
  \deqn{distance(a,b) := \sum_i{(a_i - b_i)^P}^{1/P}
    }{distance(a, b) := (\sum(a_i - b_i)^P)^(1/P)}
}
\examples{
data("block_3sp")
block <- block_3sp[, c(2, 5, 8)]
multiview(block, k = c(1, 3, "sqrt"))

}
