% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/projWiz.R
\name{trueCOGll}
\alias{trueCOGll}
\title{True centre of gravity from a set of Lat longs}
\usage{
trueCOGll(thepoints)
}
\arguments{
\item{thepoints}{set of points c(lat,long)}
}
\value{
a point (lat,long) from centre
}
\description{
Calculates the "true" centre of gravity (weighted) from a set of lat longs, using cartesian geometry
}
\examples{
lat <- runif (200,-24,-12)
long <- runif (200,43,51)
ll <- data.frame(lat,long)
cp <- trueCOGll(ll)
}
\author{
Justin Moat. J.Moat@kew.org
}
\references{
Descartes, R., 1637. Discours de la methode. A Leyde, De l’imprimerie de I. Maire, Paris.
}

