% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chart_amPie.R
\name{amPie}
\alias{amPie}
\title{Plotting pie chart}
\usage{
amPie(data, show_values = TRUE, depth = 0, inner_radius = 0, ...)
}
\arguments{
\item{data}{\code{data.frame}, dataframe with at least 2 columns : 
label (character), value (numeric). See \code{\link{data_pie}}
You can add a third column "color" (character, colors in hexadecimal).}

\item{show_values}{\code{logical}, TRUE to display values.}

\item{depth}{\code{numeric}, if > 0, chart is displayed in 3D, value
between 0 and 100}

\item{inner_radius}{\code{numeric}, value between 0 and 100}

\item{...}{see \code{\link{amOptions}} for more options.}
}
\description{
amPie computes a pie chart of the given value.
}
\examples{
data("data_pie")
amPie(data = data_pie)

\donttest{
# Other examples available which can be time consuming depending on your configuration.

# Don't display values
amPie(data = data_pie, show_values = FALSE)

# 3D pie
amPie(data = data_pie, depth = 10)

# Donut chart
amPie(data = data_pie, inner_radius = 50)

# All parameters
amPie(data = data_pie, inner_radius = 50, depth = 10, show_values = FALSE)
}
}
\references{
See online documentation \url{https://datastorm-open.github.io/introduction_ramcharts/}
and \link{amChartsAPI}
}
\seealso{
\link{amOptions}, \link{amBarplot}, \link{amBoxplot}, \link{amHist}, \link{amPie},
\link{amPlot}, \link{amTimeSeries}, \link{amStockMultiSet}, \link{amBullet}, \link{amRadar}, 
\link{amWind}, \link{amFunnel}, \link{amAngularGauge}, \link{amSolidGauge}, \link{amMekko},
\link{amCandlestick}, \link{amFloatingBar}, \link{amOHLC}, \link{amWaterfall}
}
