% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/Guide.R
\docType{methods}
\name{initialize,Guide-method}
\alias{addValueAxis,Guide-method}
\alias{guide}
\alias{initialize,Guide-method}
\alias{setFillAlpha}
\alias{setFillAlpha,Guide,numeric-method}
\alias{setValueAxis,Guide-method}
\title{Initialize a Guide}
\usage{
\S4method{initialize}{Guide}(.Object, fillAlpha, valueAxis, value, ...)

guide(fillAlpha, valueAxis, value, ...)

setFillAlpha(.Object, fillAlpha)

\S4method{setFillAlpha}{Guide,numeric}(.Object, fillAlpha)

\S4method{setValueAxis}{Guide}(.Object, valueAxis = NULL, ...)

\S4method{addValueAxis}{Guide}(.Object, valueAxis = NULL, ...)
}
\arguments{
\item{.Object}{\linkS4class{Guide}}

\item{fillAlpha}{\code{numeric}.
Specifies if a grid line is placed on the center of a cell or on the beginning of a cell.
Possible values are: "start" and "middle"
This setting doesn't work if parseDates is set to true.}

\item{valueAxis}{\linkS4class{ValueAxis} class.
As you can add guides directly to the chart, you might need to specify
which value axis should be used.}

\item{value}{\code{numeric}.}

\item{...}{Other properties.}
}
\description{
Initialize a Guide

SETTER
}
\section{Functions}{
\itemize{
\item \code{guide}: 
}}
\examples{
new("Guide", fillAlpha = 0.1, gridThickness = 1, value = 1)
guide(fillAlpha = .4, value = 1)
guide(fillAlpha = .4, adjustBorderColor = TRUE, gridThickness = 1)
setFillAlpha(.Object = guide(), fillAlpha = 1)
setValueAxis(.Object = guide(), valueAxis = list(valueAxis(test = "foo"),
                                                 valueAxis(test2 = "foo2")))
setValueAxis(.Object = guide(), valueAxis = valueAxis(test = "foo"))
addValueAxis(.Object = guide(), axisTitleOffset = 12, tickLength = 10)
valueAxis <- valueAxis(axisTitleOffset = 12, tickLength = 10)
addValueAxis(.Object = guide(), valueAxis = valueAxis)
}
\seealso{
\code{\linkS4class{Guide}} S4 class
}

