% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set.R
\name{set_max_lts}
\alias{set_max_lts}
\title{Set max Level of Transit Stress (LTS)}
\usage{
set_max_lts(r5r_core, max_lts)
}
\arguments{
\item{r5r_core}{An object to connect with the R5 routing engine, created with
\code{\link[=setup_r5]{setup_r5()}}.}

\item{max_lts}{A number (between 1 and 4). The maximum level of traffic
stress that cyclists will tolerate. A value of 1 means cyclists will only
travel through the quietest streets, while a value of 4 indicates cyclists
can travel through any road.}
}
\value{
Invisibly returns \code{TRUE}.
}
\description{
Set max Level of Transit Stress (LTS)
}
\seealso{
Other setting functions: 
\code{\link{set_breakdown}()},
\code{\link{set_cutoffs}()},
\code{\link{set_expanded_travel_times}()},
\code{\link{set_fare_cutoffs}()},
\code{\link{set_fare_structure}()},
\code{\link{set_max_fare}()},
\code{\link{set_max_rides}()},
\code{\link{set_monte_carlo_draws}()},
\code{\link{set_n_threads}()},
\code{\link{set_output_dir}()},
\code{\link{set_percentiles}()},
\code{\link{set_progress}()},
\code{\link{set_speed}()},
\code{\link{set_suboptimal_minutes}()},
\code{\link{set_time_window}()},
\code{\link{set_verbose}()}
}
\concept{setting functions}
\keyword{internal}
