% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/3JSobjects.R
\name{surface3js}
\alias{surface3js}
\title{Add a surface to an data3js object}
\usage{
surface3js(
  data3js,
  x,
  y,
  z,
  col = "black",
  mat,
  wireframe = FALSE,
  highlight,
  ...
)
}
\arguments{
\item{data3js}{The data3js object}

\item{x}{Values corresponding to rows of z, or matrix of x coordinates}

\item{y}{Values corresponding to the columns of z, or matrix of y coordinates}

\item{z}{Matrix of heights}

\item{col}{The color of the surface as either a single value, vector or matrix.}

\item{mat}{The material to use when drawing the matrix, for a solid surface the default is
"phong", for a wireframe the default is "line".}

\item{wireframe}{Logical value for if the surface should be displayed as a mesh}

\item{highlight}{highlight attributes (see \code{highlight3js()})}

\item{...}{Material and texture properties. See \code{material3js()}}
}
\value{
Returns an updated data3js object
}
\description{
This function behaves very similarly to the \code{surface3d} function in the \code{rgl}
package, although the handling of NA values are handled differently.
}
\examples{
# volcano example taken from "persp"
z <- 2 * volcano        # Exaggerate the relief
x <- 10 * (1:nrow(z))   # 10 meter spacing (S to N)
y <- 10 * (1:ncol(z))   # 10 meter spacing (E to W)

zlim <- range(z)
zlen <- zlim[2] - zlim[1] + 1

colorlut <- terrain.colors(zlen) # height color lookup table
col <- colorlut[ z - zlim[1] + 1 ] # assign colors to heights for each point

p <- plot3js(
  xlim = range(x),
  ylim = range(y),
  zlim = range(z),
  label_axes = FALSE,
  aspect = c(1, 1, 1) # Maintain a constant aspect ratio
)

p <- surface3js(
  data3js = p,
  x, y, z,
  col = col
)

r3js(
  data3js = p,
  rotation = c(-1.15, 0, -0.65),
  zoom = 1.5
)

}
\seealso{
Other plot components: 
\code{\link{arrows3js}()},
\code{\link{axis3js}()},
\code{\link{box3js}()},
\code{\link{grid3js}()},
\code{\link{legend3js}()},
\code{\link{light3js}()},
\code{\link{lines3js}()},
\code{\link{mtext3js}()},
\code{\link{points3js}()},
\code{\link{segments3js}()},
\code{\link{shape3js}()},
\code{\link{sphere3js}()},
\code{\link{text3js}()},
\code{\link{triangle3js}()}
}
\concept{plot components}
