% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set.R
\name{m_set_style}
\alias{m_set_style}
\title{Add Style to Selection}
\usage{
m_set_style(id, sel = m_sel(), style = m_style_cartoon())
}
\arguments{
\item{id}{R3dmol \code{id} or a \code{r3dmol} object (the output from
\code{r3dmol()})}

\item{sel}{Atom selection specification with \code{m_sel()}}

\item{style}{Style spec to apply to specified atoms using m_style_*()}
}
\value{
R3dmol \code{id} or a \code{r3dmol} object (the output from
\code{r3dmol()})
}
\description{
Takes a selection and adds additional styling to selection.
}
\examples{
library(r3dmol)

# Add style to model
r3dmol() \%>\%
  m_add_model(data = pdb_1j72, format = "pdb") \%>\%
  m_add_style(style = m_style_cartoon()) \%>\%
  m_zoom_to()
}
