% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prepare_site.R
\name{prepare_site}
\alias{prepare_site}
\title{Check the site data for consistency}
\usage{
prepare_site(site)
}
\arguments{
\item{site}{table containing the information about site data. It shall contain exactly one row.
\itemize{
  \item latitude: site latitude in the WGS84 coordinate system.
  \item altitude: site altitude, m a.s.l.
  \item soil_class:  soil class, according to table 2 user manual of 3PGpjs. 1 - Sandy; 2 - Sandy loam; 3 - Clay loam; 4 - Clay; 0 - No effect of available soil water on production.
  \item asw_i: initial available soil water (mm).
  \item asw_max: minimum available soil water (mm).
  \item asw_min: maximum available soil water (mm).
  \item from: year and month indicating the start of simulation. Provided in form of year-month. E.g. "2000-01".
  \item to: year and month indicating the end of simulation. Provided in form of year-month. E.g. "2009-12", will include December 2009 as last simulation month.
}}
}
\value{
a data.frame with one row
}
\description{
Prepares the site table, by checking whether the input information is consistent.
}
\details{
This function check the site table for \code{\link{run_3PG}}.
}
\examples{
# check site data
prepare_site( site = d_site)
}
\seealso{
\code{\link{run_3PG}}, \code{\link{prepare_input}}, \code{\link{prepare_parameters}}, \code{\link{prepare_sizeDist}}, \code{\link{prepare_thinning}}
}
