% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/query.R
\name{o311_query}
\alias{o311_query}
\title{Query an open311 endpoint}
\usage{
o311_query(path, ..., simplify = TRUE)
}
\arguments{
\item{path}{Path appendix used to access endpoint-specific operations.}

\item{...}{Additional query parameters.}

\item{simplify}{Whether to simplify the output using
\code{jsonlite::toJSON(..., simplify = TRUE)}.}
}
\value{
The parsed query output, either as a list or dataframe.
}
\description{
Low-level function to perform a generic request to the API currently
attached by \code{o311_api}. Some open311 implementations support
unique operations that are not included in the official documentation.
This function can be used to access these URL paths.
}
\details{
You can set \code{options(r311_echo = TRUE)} to display all requests sent
using \code{o311_query}.
}
\examples{
o311_api("rostock")
\donttest{
# manually query discovery
o311_query(path = "discovery", simplify = FALSE)

# query a custom path defined by the Klarschiff API
o311_query(path = "areas")
}
}
