% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggplot2.R
\name{theme_SPSS}
\alias{theme_SPSS}
\title{Plot theme to mimic the look of SPSS graphs}
\usage{
theme_SPSS(
  base_size = 12,
  base_family = "",
  base_line_size = 0.5,
  base_rect_size = 0.5,
  version = r2spss_options$get("version"),
  scales = NULL,
  scale.x = scales,
  scale.y = scales
)
}
\arguments{
\item{base_size}{an integer giving the base font size in pts.}

\item{base_family}{a character string giving the base font family.}

\item{base_line_size}{base size for line elements.}

\item{base_rect_size}{base size for borders of rectangle elements.}

\item{version}{a character string specifying whether to mimic the look
of recent SPSS versions (\code{"modern"}) or older versions (<24;
\code{"legacy"}).}

\item{scales, scale.x, scale.y}{a character string specifying whether both
or each of the axes are expected to be continuous (\code{"continuous"}) or
discrete (\code{"discrete"}).  Note that this only controls the appearance
of the tick labels on the axis, as the theme has no control over the
information that is displayed in the plot.  SPSS displays larger tick
labels a for discrete axis than for a continuous axis, hence specifying
this information in the theme adjusts the tick label size accordingly.
The default (\code{NULL}) means that the tick labels are of the same size
as for a continuous axis.}
}
\description{
Complete theme that controls all non-data display of a plot to mimic the
look of SPSS graphs.  Use \code{\link[ggplot2]{theme}} after
\code{theme_SPSS} to further tweak the display.
}
\examples{
# data to be plotted
df <- data.frame(x = 1:30, y = 0)

# initialize plot
p <- ggplot(aes(x = x, y = y, fill = factor(x)), data = df) +
  geom_point(shape = 21, size = 3, show.legend = FALSE) +
  theme_SPSS()

# colors of modern SPSS versions
p + theme_SPSS() + scale_fill_SPSS()

# colors of legacy SPSS versions
p + theme_SPSS(version = "legacy") +
  scale_fill_SPSS(version = "legacy")

}
\keyword{aplot}
