% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/histogram.R
\name{histogram}
\alias{histogram}
\title{Histogram}
\usage{
histogram(
  data,
  variable,
  bins = NULL,
  normal = FALSE,
  normal.colour = NULL,
  normal.color = NULL,
  normal.linetype = NULL,
  normal.size = NULL,
  normal.alpha = NULL,
  digits = 3,
  limits = NULL,
  expand = 0.05,
  version = r2spss_options$get("version"),
  ...
)
}
\arguments{
\item{data}{a data frame containing the variable to be plotted.}

\item{variable}{a character string specifying the variable to be
plotted.}

\item{bins}{an integer giving the number of bins for the histogram.}

\item{normal}{a logical indicating whether to add a normal density with the
estimated mean and standard deviation (the default is \code{FALSE}).}

\item{normal.colour, normal.color, normal.linetype, normal.size, normal.alpha}{aesthetics for the normal density.  In the unlikely event that both US and
UK spellings of color are supplied, the US spelling will take precedence.}

\item{digits}{an integer giving the number of digits after the comma to be
printed in the summary statistics in the right plot margin.}

\item{limits}{a list of arguments to be passed to
\code{\link[ggplot2]{expand_limits}}.  Typically, the list would contain
components \code{x} or \code{y} to specify values that should be included
in the range of the corresponding axis.}

\item{expand}{a numeric value specifying the percentage of the range to be
used for padding the axes.  The default is 0.05 to expand the \eqn{x}-axis
by 5\% on both sides and the \eqn{y}-axis by 5\% on the upper end.  Note
that there is no padding on lower end of the \eqn{y}-axis to mimic SPSS
behavior.}

\item{version}{a character string specifying whether the plot should mimic
the look of recent SPSS versions (\code{"modern"}) or older versions (<24;
\code{"legacy"}).}

\item{\dots}{additional arguments to be passed down, in particular
aesthetics (see \code{\link[ggplot2]{geom_histogram}} and
\code{\link[ggplot2]{geom_line}}).}
}
\value{
An object of class \code{"\link[ggplot2]{ggplot}"}, which produces
a histogram when printed.
}
\description{
Draw a histogram of a variable in a data frame.  The plot thereby mimics the
look of SPSS graphs.
}
\note{
Due to the inner workings of this function to mimic the look
of histograms in SPSS, it is not expected that the user adds
\code{\link[ggplot2]{scale_x_continuous}} or
\code{\link[ggplot2]{scale_y_continuous}} to the plot.  Instead, axis
limits and padding should be modified via the \code{limits} and
\code{expand} arguments.
}
\examples{
# load data
data("Eredivisie")
# log-transform market values
Eredivisie$logMarketValue <- log(Eredivisie$MarketValue)

# plot histogram of log market values
histogram(Eredivisie, "logMarketValue", normal = TRUE,
          limits = list(x = c(9.5, 17.5)))

}
\author{
Andreas Alfons
}
\keyword{hplot}
