% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{boxplotSPSS}
\alias{boxplotSPSS}
\title{Boxplots}
\usage{
boxplotSPSS(
  data,
  variables,
  group = NULL,
  xlab = NULL,
  ylab = NULL,
  cut.names = NULL,
  ...
)
}
\arguments{
\item{data}{a data frame containing the variables to be plotted.}

\item{variables}{a character vector specifying separate variables to be
plotted.  If \code{group} is not \code{NULL}, only the first variable is
used and boxplots of groups of observations are drawn instead.}

\item{group}{an character string specifying a grouping variable, or
\code{NULL} for no grouping.}

\item{xlab, ylab}{the axis labels.}

\item{cut.names}{a logical indicating whether to cut long variable names or
group labels to 8 characters.  The default is \code{TRUE} for boxplots of
separate variables, but \code{FALSE} for boxplots of groups of observations
(which mimics SPSS behavior).}

\item{\dots}{additional arguments to be passed down, in particular
graphical parameters (see \code{\link[graphics]{boxplot}} and
\code{\link[graphics]{par}}).}
}
\value{
A list containing summary statistics is returned invisibly (see
\code{\link[graphics]{boxplot}}).
}
\description{
Draw boxplots of variables in a data frame, including boxplots for groups of
observations and boxplots for separate variables.  The plots thereby mimic
the look of SPSS graphs.
}
\examples{
## paired sample
# load data
data("Exams")

# plot grades on regular and resit exams
boxplotSPSS(Exams, c("Regular", "Resit"))


## independent samples

# load data
data("Eredivisie")
# log-transform market values
Eredivisie$logMarketValue <- log(Eredivisie$MarketValue)

# plot log market values of Dutch and Foreign players
boxplotSPSS(Eredivisie, "logMarketValue", group = "Foreign")

}
\author{
Andreas Alfons
}
\keyword{hplot}
