/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.rexp;

import java.util.List;
import org.dmg.pmml.DataField;
import org.dmg.pmml.DataType;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.MiningFunction;
import org.dmg.pmml.Model;
import org.dmg.pmml.OpType;
import org.dmg.pmml.mining.MiningModel;
import org.dmg.pmml.mining.Segmentation;
import org.dmg.pmml.regression.RegressionModel;
import org.dmg.pmml.tree.TreeModel;
import org.jpmml.converter.ModelUtil;
import org.jpmml.converter.Schema;
import org.jpmml.converter.Transformation;
import org.jpmml.converter.mining.MiningModelUtil;
import org.jpmml.rexp.EmptyFormulaContext;
import org.jpmml.rexp.Formula;
import org.jpmml.rexp.FormulaUtil;
import org.jpmml.rexp.RDoubleVector;
import org.jpmml.rexp.RExp;
import org.jpmml.rexp.RExpEncoder;
import org.jpmml.rexp.RFactorVector;
import org.jpmml.rexp.RGenericVector;
import org.jpmml.rexp.RIntegerVector;
import org.jpmml.rexp.RPartConverter;
import org.jpmml.rexp.RPartEnsembleConverter;

public class AdaConverter
extends RPartEnsembleConverter<RGenericVector> {
    public AdaConverter(RGenericVector ada) {
        super(ada);
    }

    @Override
    public RPartConverter createConverter(RGenericVector rpart) {
        return new RPartConverter(rpart){

            @Override
            public boolean hasScoreDistribution() {
                return false;
            }

            @Override
            public TreeModel encodeModel(Schema schema) {
                TreeModel treeModel = super.encodeModel(schema).setMiningFunction(MiningFunction.REGRESSION);
                return treeModel;
            }
        };
    }

    @Override
    public void encodeSchema(RExpEncoder encoder) {
        RGenericVector ada = (RGenericVector)this.getObject();
        if (ada.hasElement("terms")) {
            this.encodeFormula(encoder);
        } else {
            this.encodeNonFormula(encoder);
        }
    }

    @Override
    public Model encodeModel(Schema schema) {
        RGenericVector ada = (RGenericVector)this.getObject();
        RGenericVector model = ada.getGenericElement("model");
        RGenericVector trees = model.getGenericElement("trees");
        RDoubleVector alpha = model.getDoubleElement("alpha");
        List<TreeModel> treeModels = this.encodeTreeModels(trees);
        MiningModel miningModel = new MiningModel(MiningFunction.REGRESSION, ModelUtil.createMiningSchema(null)).setSegmentation(MiningModelUtil.createSegmentation((Segmentation.MultipleModelMethod)Segmentation.MultipleModelMethod.WEIGHTED_SUM, treeModels, alpha.getValues())).setOutput(ModelUtil.createPredictedOutput((FieldName)FieldName.create((String)"adaValue"), (OpType)OpType.CONTINUOUS, (DataType)DataType.DOUBLE, (Transformation[])new Transformation[0]));
        return MiningModelUtil.createBinaryLogisticClassification((Model)miningModel, (double)2.0, (double)0.0, (RegressionModel.NormalizationMethod)RegressionModel.NormalizationMethod.LOGIT, (boolean)true, (Schema)schema);
    }

    private void encodeFormula(RExpEncoder encoder) {
        RGenericVector ada = (RGenericVector)this.getObject();
        RGenericVector model = ada.getGenericElement("model");
        RExp terms = (RExp)ada.getElement("terms");
        RIntegerVector fit = ada.getIntegerElement("fit");
        RGenericVector trees = model.getGenericElement("trees");
        RExpEncoder termsEncoder = new RExpEncoder();
        EmptyFormulaContext context = new EmptyFormulaContext();
        Formula formula = FormulaUtil.createFormula(terms, context, termsEncoder);
        FormulaUtil.setLabel(formula, terms, fit, encoder);
        this.encodeTreeSchemas(trees, encoder);
    }

    private void encodeNonFormula(RExpEncoder encoder) {
        RGenericVector ada = (RGenericVector)this.getObject();
        RGenericVector model = ada.getGenericElement("model");
        RFactorVector fit = ada.getFactorElement("fit");
        RGenericVector trees = model.getGenericElement("trees");
        DataField dataField = encoder.createDataField(FieldName.create((String)"_target"), OpType.CATEGORICAL, DataType.STRING, fit.getLevelValues());
        encoder.setLabel(dataField);
        this.encodeTreeSchemas(trees, encoder);
    }
}

