/*
 * Decompiled with CFR 0.152.
 */
package org.dmg.pmml;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY, getterVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
public final class FieldName
implements Serializable {
    @JsonValue
    private String value = null;
    public static final Map<String, FieldName> CACHE = new ConcurrentHashMap<String, FieldName>(2048);
    public static final ThreadLocal<Map<String, FieldName>> CACHE_PROVIDER = new ThreadLocal<Map<String, FieldName>>(){

        @Override
        protected Map<String, FieldName> initialValue() {
            return CACHE;
        }
    };

    private FieldName(String value) {
        this.setValue(value);
    }

    public int hashCode() {
        return this.getValue().hashCode();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof FieldName) {
            FieldName that = (FieldName)object;
            return this.getValue().equals(that.getValue());
        }
        return false;
    }

    public String toString() {
        return this.getValue();
    }

    public String getValue() {
        return this.value;
    }

    private void setValue(String value) {
        if (value == null) {
            throw new NullPointerException();
        }
        this.value = value;
    }

    final Object readResolve() {
        return FieldName.create(this.getValue());
    }

    @JsonCreator
    public static FieldName create(String value) {
        FieldName prevName;
        if (value == null) {
            throw new NullPointerException();
        }
        if ("".equals(value)) {
            throw new IllegalArgumentException("Name cannot be empty");
        }
        Map<String, FieldName> cache = CACHE_PROVIDER.get();
        FieldName name = cache.get(value);
        if (name == null && (prevName = cache.putIfAbsent(value, name = new FieldName(value))) != null) {
            return prevName;
        }
        return name;
    }
}

