% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/co2_intensity_scenario_demo.R
\docType{data}
\name{co2_intensity_scenario_demo}
\alias{co2_intensity_scenario_demo}
\title{A prepared co2 intensity climate scenario dataset for demonstration}
\format{
An object of class \code{tbl_df} (inherits from \code{tbl}, \code{data.frame}) with 22 rows and 7 columns.
}
\usage{
co2_intensity_scenario_demo
}
\description{
Fake co2 intensity climate scenario dataset, prepared for the software
PACTA (Paris Agreement Capital Transition Assessment). It imitates
climate scenario data (e.g. from the International Energy Agency (IEA))
including the change through time in production across industrial sectors
(calculated by \href{https://2degrees-investing.org/}{2DII}).

Demo datasets are synthetic because most financial data is strictly private;
they help to demonstrate and test the implementation in R of 'PACTA'
(\url{https://2degrees-investing.org/resource/pacta/}).
}
\section{Definitions}{

\itemize{
\item \code{ald_emission_factor_unit} (character): The units that the emission factor is measured in.
\item \code{ald_timestamp} (character): Date at which asset data was pulled from database.
\item \code{country_of_domicile} (character): Country where company is registered.
\item \code{emission_factor} (double): Company level emission factor of the technology.
\item \code{is_ultimate_listed_owner} (logical): Flag if company is the listed ultimate parent.
\item \code{is_ultimate_owner} (logical): Flag if company is the ultimate parent in our database.
\item \code{name_company} (character): The name of the company owning the asset.
\item \code{number_of_assets} (integer): Number of assets of a given technology owned by the company.
\item \code{plant_location} (character): Country where asset is located.
\item \code{production} (double): Company level production of the technology.
\item \code{production_unit} (character): The units that production is measured in.
\item \code{sector} (character): Sector to which the asset belongs.
\item \code{technology} (character): Technology implemented by the asset.
\item \code{year} (integer): Year at which the production value is predicted.
}
}

\examples{
head(co2_intensity_scenario_demo)
}
\seealso{
\link{data_dictionary}

Other demo datasets: 
\code{\link{ald_demo}},
\code{\link{loanbook_demo}},
\code{\link{overwrite_demo}},
\code{\link{region_isos_demo}},
\code{\link{scenario_demo_2020}}
}
\concept{demo datasets}
\keyword{datasets}
