% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{traprule}
\alias{traprule}
\title{Trapezoid Rule Numeric Integration}
\usage{
traprule(x, y)
}
\arguments{
\item{x, y}{numeric vectors of equal length}
}
\value{
a numeric value, the estimated integral
}
\description{
Compute the integral of y with respect to x via trapezoid rule.
}
\examples{
xvec <- seq(-2 * pi, 3 * pi, length = 560)
foo  <- function(x) { sin(x) + x * cos(x) + 12 }
yvec <- foo(xvec)
plot(xvec, yvec, type = "l")

integrate(f = foo, lower = -2 * pi, upper = 3 * pi)
traprule(xvec, yvec)

}
