% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/median_iqr.R
\name{median_iqr}
\alias{median_iqr}
\title{Median and Inner Quartile Range}
\usage{
median_iqr(x, digits = getOption("qwraps2_frmt_digits", 2), na_rm = FALSE,
  show_n = "ifNA", markup = getOption("qwraps2_markup", "latex"))
}
\arguments{
\item{x}{a numeric vector}

\item{digits}{digits to the right of the decimal point to return.}

\item{na_rm}{if true, omit NA values (NOT CURRENTLY IMPLEMENTED)}

\item{show_n}{defaults to "ifNA".  Other options are "always" or "never".}

\item{markup}{latex or markdown}
}
\value{
a character vector of the formatted values
}
\description{
A function for calculating and formatting the median and
inner quartile range of a data vector.
#'
}
\details{
Given a numeric vector, \code{median_iqr} will return a character string with
the median and IQR.  Formating of the output will be extended in
future versions.
}
\examples{
set.seed(42)
x <- rnorm(1000, 3, 4)
median(x)
quantile(x, probs = c(1, 3)/4)
median_iqr(x)
median_iqr(x, show_n = "always")

x[187] <- NA
# median_iqr(x) ## Will error
median_iqr(x, na_rm = TRUE)
}

