# gen_centroids() works

    Code
      centroid_list
    Output
      $hexID
       [1]  1  2  3  4  5  6  7  8  9 10 11 12 13 14 15 16 17 18 19 20 21 22 23 24 25
      [26] 26 27 28 29 30 31 32 33 34 35 36 37 38 39 40
      
      $c_x
       [1] -0.1732051  0.1732051  0.5196152  0.8660254  1.2124356  0.0000000
       [7]  0.3464102  0.6928203  1.0392305  1.3856406 -0.1732051  0.1732051
      [13]  0.5196152  0.8660254  1.2124356  0.0000000  0.3464102  0.6928203
      [19]  1.0392305  1.3856406 -0.1732051  0.1732051  0.5196152  0.8660254
      [25]  1.2124356  0.0000000  0.3464102  0.6928203  1.0392305  1.3856406
      [31] -0.1732051  0.1732051  0.5196152  0.8660254  1.2124356  0.0000000
      [37]  0.3464102  0.6928203  1.0392305  1.3856406
      
      $c_y
       [1] -0.15 -0.15 -0.15 -0.15 -0.15  0.15  0.15  0.15  0.15  0.15  0.45  0.45
      [13]  0.45  0.45  0.45  0.75  0.75  0.75  0.75  0.75  1.05  1.05  1.05  1.05
      [25]  1.05  1.35  1.35  1.35  1.35  1.35  1.65  1.65  1.65  1.65  1.65  1.95
      [37]  1.95  1.95  1.95  1.95
      

# gen_hex_coord() works

    Code
      all_hex_coordinates_list
    Output
      $hex_poly_id
        [1]  1  1  1  1  1  1  2  2  2  2  2  2  3  3  3  3  3  3  4  4  4  4  4  4  5
       [26]  5  5  5  5  5  6  6  6  6  6  6  7  7  7  7  7  7  8  8  8  8  8  8  9  9
       [51]  9  9  9  9 10 10 10 10 10 10 11 11 11 11 11 11 12 12 12 12 12 12 13 13 13
       [76] 13 13 13 14 14 14 14 14 14 15 15 15 15 15 15 16 16 16 16 16 16 17 17 17 17
      [101] 17 17 18 18 18 18 18 18 19 19 19 19 19 19 20 20 20 20 20 20 21 21 21 21 21
      [126] 21 22 22 22 22 22 22 23 23 23 23 23 23 24 24 24 24 24 24 25 25 25 25 25 25
      [151] 26 26 26 26 26 26 27 27 27 27 27 27 28 28 28 28 28 28 29 29 29 29 29 29 30
      [176] 30 30 30 30 30 31 31 31 31 31 31 32 32 32 32 32 32 33 33 33 33 33 33 34 34
      [201] 34 34 34 34 35 35 35 35 35 35 36 36 36 36 36 36 37 37 37 37 37 37 38 38 38
      [226] 38 38 38 39 39 39 39 39 39 40 40 40 40 40 40
      
      $x
        [1]  0.0000000  0.0000000 -0.1732051 -0.3464102 -0.3464102 -0.1732051
        [7]  0.3464102  0.3464102  0.1732051  0.0000000  0.0000000  0.1732051
       [13]  0.6928203  0.6928203  0.5196152  0.3464102  0.3464102  0.5196152
       [19]  1.0392305  1.0392305  0.8660254  0.6928203  0.6928203  0.8660254
       [25]  1.3856406  1.3856406  1.2124356  1.0392305  1.0392305  1.2124356
       [31]  0.1732051  0.1732051  0.0000000 -0.1732051 -0.1732051  0.0000000
       [37]  0.5196152  0.5196152  0.3464102  0.1732051  0.1732051  0.3464102
       [43]  0.8660254  0.8660254  0.6928203  0.5196152  0.5196152  0.6928203
       [49]  1.2124356  1.2124356  1.0392305  0.8660254  0.8660254  1.0392305
       [55]  1.5588457  1.5588457  1.3856406  1.2124356  1.2124356  1.3856406
       [61]  0.0000000  0.0000000 -0.1732051 -0.3464102 -0.3464102 -0.1732051
       [67]  0.3464102  0.3464102  0.1732051  0.0000000  0.0000000  0.1732051
       [73]  0.6928203  0.6928203  0.5196152  0.3464102  0.3464102  0.5196152
       [79]  1.0392305  1.0392305  0.8660254  0.6928203  0.6928203  0.8660254
       [85]  1.3856406  1.3856406  1.2124356  1.0392305  1.0392305  1.2124356
       [91]  0.1732051  0.1732051  0.0000000 -0.1732051 -0.1732051  0.0000000
       [97]  0.5196152  0.5196152  0.3464102  0.1732051  0.1732051  0.3464102
      [103]  0.8660254  0.8660254  0.6928203  0.5196152  0.5196152  0.6928203
      [109]  1.2124356  1.2124356  1.0392305  0.8660254  0.8660254  1.0392305
      [115]  1.5588457  1.5588457  1.3856406  1.2124356  1.2124356  1.3856406
      [121]  0.0000000  0.0000000 -0.1732051 -0.3464102 -0.3464102 -0.1732051
      [127]  0.3464102  0.3464102  0.1732051  0.0000000  0.0000000  0.1732051
      [133]  0.6928203  0.6928203  0.5196152  0.3464102  0.3464102  0.5196152
      [139]  1.0392305  1.0392305  0.8660254  0.6928203  0.6928203  0.8660254
      [145]  1.3856406  1.3856406  1.2124356  1.0392305  1.0392305  1.2124356
      [151]  0.1732051  0.1732051  0.0000000 -0.1732051 -0.1732051  0.0000000
      [157]  0.5196152  0.5196152  0.3464102  0.1732051  0.1732051  0.3464102
      [163]  0.8660254  0.8660254  0.6928203  0.5196152  0.5196152  0.6928203
      [169]  1.2124356  1.2124356  1.0392305  0.8660254  0.8660254  1.0392305
      [175]  1.5588457  1.5588457  1.3856406  1.2124356  1.2124356  1.3856406
      [181]  0.0000000  0.0000000 -0.1732051 -0.3464102 -0.3464102 -0.1732051
      [187]  0.3464102  0.3464102  0.1732051  0.0000000  0.0000000  0.1732051
      [193]  0.6928203  0.6928203  0.5196152  0.3464102  0.3464102  0.5196152
      [199]  1.0392305  1.0392305  0.8660254  0.6928203  0.6928203  0.8660254
      [205]  1.3856406  1.3856406  1.2124356  1.0392305  1.0392305  1.2124356
      [211]  0.1732051  0.1732051  0.0000000 -0.1732051 -0.1732051  0.0000000
      [217]  0.5196152  0.5196152  0.3464102  0.1732051  0.1732051  0.3464102
      [223]  0.8660254  0.8660254  0.6928203  0.5196152  0.5196152  0.6928203
      [229]  1.2124356  1.2124356  1.0392305  0.8660254  0.8660254  1.0392305
      [235]  1.5588457  1.5588457  1.3856406  1.2124356  1.2124356  1.3856406
      
      $y
        [1] -0.05040708 -0.24959292 -0.34918584 -0.24959292 -0.05040708  0.04918584
        [7] -0.05040708 -0.24959292 -0.34918584 -0.24959292 -0.05040708  0.04918584
       [13] -0.05040708 -0.24959292 -0.34918584 -0.24959292 -0.05040708  0.04918584
       [19] -0.05040708 -0.24959292 -0.34918584 -0.24959292 -0.05040708  0.04918584
       [25] -0.05040708 -0.24959292 -0.34918584 -0.24959292 -0.05040708  0.04918584
       [31]  0.24959292  0.05040708 -0.04918584  0.05040708  0.24959292  0.34918584
       [37]  0.24959292  0.05040708 -0.04918584  0.05040708  0.24959292  0.34918584
       [43]  0.24959292  0.05040708 -0.04918584  0.05040708  0.24959292  0.34918584
       [49]  0.24959292  0.05040708 -0.04918584  0.05040708  0.24959292  0.34918584
       [55]  0.24959292  0.05040708 -0.04918584  0.05040708  0.24959292  0.34918584
       [61]  0.54959292  0.35040708  0.25081416  0.35040708  0.54959292  0.64918584
       [67]  0.54959292  0.35040708  0.25081416  0.35040708  0.54959292  0.64918584
       [73]  0.54959292  0.35040708  0.25081416  0.35040708  0.54959292  0.64918584
       [79]  0.54959292  0.35040708  0.25081416  0.35040708  0.54959292  0.64918584
       [85]  0.54959292  0.35040708  0.25081416  0.35040708  0.54959292  0.64918584
       [91]  0.84959292  0.65040708  0.55081416  0.65040708  0.84959292  0.94918584
       [97]  0.84959292  0.65040708  0.55081416  0.65040708  0.84959292  0.94918584
      [103]  0.84959292  0.65040708  0.55081416  0.65040708  0.84959292  0.94918584
      [109]  0.84959292  0.65040708  0.55081416  0.65040708  0.84959292  0.94918584
      [115]  0.84959292  0.65040708  0.55081416  0.65040708  0.84959292  0.94918584
      [121]  1.14959292  0.95040708  0.85081416  0.95040708  1.14959292  1.24918584
      [127]  1.14959292  0.95040708  0.85081416  0.95040708  1.14959292  1.24918584
      [133]  1.14959292  0.95040708  0.85081416  0.95040708  1.14959292  1.24918584
      [139]  1.14959292  0.95040708  0.85081416  0.95040708  1.14959292  1.24918584
      [145]  1.14959292  0.95040708  0.85081416  0.95040708  1.14959292  1.24918584
      [151]  1.44959292  1.25040708  1.15081416  1.25040708  1.44959292  1.54918584
      [157]  1.44959292  1.25040708  1.15081416  1.25040708  1.44959292  1.54918584
      [163]  1.44959292  1.25040708  1.15081416  1.25040708  1.44959292  1.54918584
      [169]  1.44959292  1.25040708  1.15081416  1.25040708  1.44959292  1.54918584
      [175]  1.44959292  1.25040708  1.15081416  1.25040708  1.44959292  1.54918584
      [181]  1.74959292  1.55040708  1.45081416  1.55040708  1.74959292  1.84918584
      [187]  1.74959292  1.55040708  1.45081416  1.55040708  1.74959292  1.84918584
      [193]  1.74959292  1.55040708  1.45081416  1.55040708  1.74959292  1.84918584
      [199]  1.74959292  1.55040708  1.45081416  1.55040708  1.74959292  1.84918584
      [205]  1.74959292  1.55040708  1.45081416  1.55040708  1.74959292  1.84918584
      [211]  2.04959292  1.85040708  1.75081416  1.85040708  2.04959292  2.14918584
      [217]  2.04959292  1.85040708  1.75081416  1.85040708  2.04959292  2.14918584
      [223]  2.04959292  1.85040708  1.75081416  1.85040708  2.04959292  2.14918584
      [229]  2.04959292  1.85040708  1.75081416  1.85040708  2.04959292  2.14918584
      [235]  2.04959292  1.85040708  1.75081416  1.85040708  2.04959292  2.14918584
      

# assign_data() works

    Code
      nldr_with_hb_id_list
    Output
      $UMAP1
       [1] 0.08044271 0.73857864 0.83992020 0.16719939 0.26292782 0.83820653
       [7] 0.73364820 0.62693057 0.80998347 0.90342138 0.64241759 0.05182936
      [13] 0.96228699 0.07223295 0.64916340 0.80783543 0.13518498 0.80668446
      [19] 0.60311661 0.16150976 0.71326033 0.09405763 0.08900367 0.77510396
      [25] 0.79296306 0.28575187 0.46806684 0.57541142 0.21053454 0.62412077
      [31] 0.76738169 0.76427076 0.64842247 0.03170275 0.96450414 0.10117880
      [37] 0.71265285 0.82904448 0.81275032 0.00000000 0.38392618 0.82638316
      [43] 0.29256853 0.84482412 0.79995094 0.69339205 0.13459287 0.04209521
      [49] 0.94245034 0.05349536 0.68677026 0.77828853 0.75504949 0.23125328
      [55] 0.76831122 0.69843891 0.72681720 0.99318862 0.96227596 0.39315580
      [61] 0.74175661 0.94650462 0.50932690 1.00000000 0.33548077 0.25450458
      [67] 0.88588122 0.72192354 0.68029522 0.92537063 0.80964667 0.49582819
      [73] 0.16301062 0.29499615 0.91053035
      
      $UMAP2
       [1] 0.274498327 0.859778569 0.929412446 0.037066861 0.341734583 1.720961652
       [7] 0.833935370 0.618409921 0.868291303 1.600664528 0.631646064 0.320865388
      [13] 1.546732900 0.218331864 0.593427000 1.374772146 0.335559538 1.381019256
      [19] 0.597381477 0.009905107 0.797282390 0.058760856 0.252258947 1.730112607
      [25] 1.100876246 0.202379969 0.482713207 0.708486670 0.151933039 0.712391079
      [31] 1.018811832 1.552630670 0.661926514 0.303630086 1.665355817 0.050909321
      [37] 1.539719959 1.722765733 1.732050808 0.271778584 0.390190144 1.011632238
      [43] 0.138015108 0.983163036 0.964486583 1.448210796 0.000000000 0.257916294
      [49] 1.680924200 0.187982579 0.778563498 0.839937252 1.670893354 0.061042472
      [55] 1.497157149 1.621642749 0.931757885 1.521102615 1.546125959 0.328235991
      [61] 1.681926517 1.524113512 0.617404710 1.625538768 0.278688714 0.063074584
      [67] 1.408512652 0.952956061 1.508729997 1.455380663 1.529334517 0.604985028
      [73] 0.030266486 0.117297635 1.445460921
      
      $hb_id
       [1]  6 18 24  2 12 34 18 18 18 34 18 12 34  6 18 28 12 28 13  2 18  6  6 34 24
      [26]  7 13 18  7 18 24 34 18  6 34  6 34 34 34  6 13 24  7 24 24 28  2  6 34  6
      [51] 18 18 34  7 28 34 24 29 34 13 34 34 13 34  7  7 29 24 28 29 34 13  2  7 29
      

# compute_std_counts() works

    Code
      std_counst_list
    Output
      $hb_id
       [1]  2  6  7 12 13 18 24 28 29 34
      
      $std_counts
       [1] 0.2352941 0.5294118 0.4117647 0.1764706 0.3529412 0.7058824 0.4705882
       [8] 0.2941176 0.2352941 1.0000000
      

# find_pts() works

    Code
      find_pts(data_hex_id = umap_with_hb_id)
    Output
      $hexID
       [1]  6 18 24  2 12 34 28 13  7 29
      
      $pts_list
      $pts_list$`Points in hexID: 6`
       [1]   1   2   3   4   6   7   8   9  11  12  14  15  16  17  19  20  21  22  23
      [20]  24  25  26  31  33  34  35  37  38  39  40  41  42  43  44  45  46  47  51
      [39]  52  54  55  56  57  59  60  62  63  64  65  66  67  69  70  71  72  73  74
      [58]  75  76  77  78  79  80  81  84  87  89  91  93  94  95  96  97  99 100
      
      $pts_list$`Points in hexID: 18`
       [1]   1   2   3   4   6   7   8   9  11  12  14  15  16  17  19  20  21  22  23
      [20]  24  25  26  31  33  34  35  37  38  39  40  41  42  43  44  45  46  47  51
      [39]  52  54  55  56  57  59  60  62  63  64  65  66  67  69  70  71  72  73  74
      [58]  75  76  77  78  79  80  81  84  87  89  91  93  94  95  96  97  99 100
      
      $pts_list$`Points in hexID: 24`
       [1]   1   2   3   4   6   7   8   9  11  12  14  15  16  17  19  20  21  22  23
      [20]  24  25  26  31  33  34  35  37  38  39  40  41  42  43  44  45  46  47  51
      [39]  52  54  55  56  57  59  60  62  63  64  65  66  67  69  70  71  72  73  74
      [58]  75  76  77  78  79  80  81  84  87  89  91  93  94  95  96  97  99 100
      
      $pts_list$`Points in hexID: 2`
       [1]   1   2   3   4   6   7   8   9  11  12  14  15  16  17  19  20  21  22  23
      [20]  24  25  26  31  33  34  35  37  38  39  40  41  42  43  44  45  46  47  51
      [39]  52  54  55  56  57  59  60  62  63  64  65  66  67  69  70  71  72  73  74
      [58]  75  76  77  78  79  80  81  84  87  89  91  93  94  95  96  97  99 100
      
      $pts_list$`Points in hexID: 12`
       [1]   1   2   3   4   6   7   8   9  11  12  14  15  16  17  19  20  21  22  23
      [20]  24  25  26  31  33  34  35  37  38  39  40  41  42  43  44  45  46  47  51
      [39]  52  54  55  56  57  59  60  62  63  64  65  66  67  69  70  71  72  73  74
      [58]  75  76  77  78  79  80  81  84  87  89  91  93  94  95  96  97  99 100
      
      $pts_list$`Points in hexID: 34`
       [1]   1   2   3   4   6   7   8   9  11  12  14  15  16  17  19  20  21  22  23
      [20]  24  25  26  31  33  34  35  37  38  39  40  41  42  43  44  45  46  47  51
      [39]  52  54  55  56  57  59  60  62  63  64  65  66  67  69  70  71  72  73  74
      [58]  75  76  77  78  79  80  81  84  87  89  91  93  94  95  96  97  99 100
      
      $pts_list$`Points in hexID: 28`
       [1]   1   2   3   4   6   7   8   9  11  12  14  15  16  17  19  20  21  22  23
      [20]  24  25  26  31  33  34  35  37  38  39  40  41  42  43  44  45  46  47  51
      [39]  52  54  55  56  57  59  60  62  63  64  65  66  67  69  70  71  72  73  74
      [58]  75  76  77  78  79  80  81  84  87  89  91  93  94  95  96  97  99 100
      
      $pts_list$`Points in hexID: 13`
       [1]   1   2   3   4   6   7   8   9  11  12  14  15  16  17  19  20  21  22  23
      [20]  24  25  26  31  33  34  35  37  38  39  40  41  42  43  44  45  46  47  51
      [39]  52  54  55  56  57  59  60  62  63  64  65  66  67  69  70  71  72  73  74
      [58]  75  76  77  78  79  80  81  84  87  89  91  93  94  95  96  97  99 100
      
      $pts_list$`Points in hexID: 7`
       [1]   1   2   3   4   6   7   8   9  11  12  14  15  16  17  19  20  21  22  23
      [20]  24  25  26  31  33  34  35  37  38  39  40  41  42  43  44  45  46  47  51
      [39]  52  54  55  56  57  59  60  62  63  64  65  66  67  69  70  71  72  73  74
      [58]  75  76  77  78  79  80  81  84  87  89  91  93  94  95  96  97  99 100
      
      $pts_list$`Points in hexID: 29`
       [1]   1   2   3   4   6   7   8   9  11  12  14  15  16  17  19  20  21  22  23
      [20]  24  25  26  31  33  34  35  37  38  39  40  41  42  43  44  45  46  47  51
      [39]  52  54  55  56  57  59  60  62  63  64  65  66  67  69  70  71  72  73  74
      [58]  75  76  77  78  79  80  81  84  87  89  91  93  94  95  96  97  99 100
      
      

# hex_binning() works

    Code
      suppressMessages(hex_binning(data = s_curve_noise_umap_scaled, x = "UMAP1", y = "UMAP2",
        num_bins_x = num_bins_x, num_bins_y = num_bins_y, x_start = NA, y_start = NA,
        buffer_x = NA, buffer_y = NA, hex_size = NA, col_start = "UMAP"))
    Output
      $centroids
      $centroids$hexID
       [1]  1  2  3  4  5  6  7  8  9 10 11 12 13 14 15 16 17 18 19 20 21 22 23 24 25
      [26] 26 27 28 29 30 31 32 33 34 35 36 37 38 39 40
      
      $centroids$c_x
       [1] -0.1732051  0.1732051  0.5196152  0.8660254  1.2124356  0.0000000
       [7]  0.3464102  0.6928203  1.0392305  1.3856406 -0.1732051  0.1732051
      [13]  0.5196152  0.8660254  1.2124356  0.0000000  0.3464102  0.6928203
      [19]  1.0392305  1.3856406 -0.1732051  0.1732051  0.5196152  0.8660254
      [25]  1.2124356  0.0000000  0.3464102  0.6928203  1.0392305  1.3856406
      [31] -0.1732051  0.1732051  0.5196152  0.8660254  1.2124356  0.0000000
      [37]  0.3464102  0.6928203  1.0392305  1.3856406
      
      $centroids$c_y
       [1] -0.15 -0.15 -0.15 -0.15 -0.15  0.15  0.15  0.15  0.15  0.15  0.45  0.45
      [13]  0.45  0.45  0.45  0.75  0.75  0.75  0.75  0.75  1.05  1.05  1.05  1.05
      [25]  1.05  1.35  1.35  1.35  1.35  1.35  1.65  1.65  1.65  1.65  1.65  1.95
      [37]  1.95  1.95  1.95  1.95
      
      
      $hex_poly
      $hex_poly$hex_poly_id
        [1]  1  1  1  1  1  1  2  2  2  2  2  2  3  3  3  3  3  3  4  4  4  4  4  4  5
       [26]  5  5  5  5  5  6  6  6  6  6  6  7  7  7  7  7  7  8  8  8  8  8  8  9  9
       [51]  9  9  9  9 10 10 10 10 10 10 11 11 11 11 11 11 12 12 12 12 12 12 13 13 13
       [76] 13 13 13 14 14 14 14 14 14 15 15 15 15 15 15 16 16 16 16 16 16 17 17 17 17
      [101] 17 17 18 18 18 18 18 18 19 19 19 19 19 19 20 20 20 20 20 20 21 21 21 21 21
      [126] 21 22 22 22 22 22 22 23 23 23 23 23 23 24 24 24 24 24 24 25 25 25 25 25 25
      [151] 26 26 26 26 26 26 27 27 27 27 27 27 28 28 28 28 28 28 29 29 29 29 29 29 30
      [176] 30 30 30 30 30 31 31 31 31 31 31 32 32 32 32 32 32 33 33 33 33 33 33 34 34
      [201] 34 34 34 34 35 35 35 35 35 35 36 36 36 36 36 36 37 37 37 37 37 37 38 38 38
      [226] 38 38 38 39 39 39 39 39 39 40 40 40 40 40 40
      
      $hex_poly$x
        [1]  0.0000000  0.0000000 -0.1732051 -0.3464102 -0.3464102 -0.1732051
        [7]  0.3464102  0.3464102  0.1732051  0.0000000  0.0000000  0.1732051
       [13]  0.6928203  0.6928203  0.5196152  0.3464102  0.3464102  0.5196152
       [19]  1.0392305  1.0392305  0.8660254  0.6928203  0.6928203  0.8660254
       [25]  1.3856406  1.3856406  1.2124356  1.0392305  1.0392305  1.2124356
       [31]  0.1732051  0.1732051  0.0000000 -0.1732051 -0.1732051  0.0000000
       [37]  0.5196152  0.5196152  0.3464102  0.1732051  0.1732051  0.3464102
       [43]  0.8660254  0.8660254  0.6928203  0.5196152  0.5196152  0.6928203
       [49]  1.2124356  1.2124356  1.0392305  0.8660254  0.8660254  1.0392305
       [55]  1.5588457  1.5588457  1.3856406  1.2124356  1.2124356  1.3856406
       [61]  0.0000000  0.0000000 -0.1732051 -0.3464102 -0.3464102 -0.1732051
       [67]  0.3464102  0.3464102  0.1732051  0.0000000  0.0000000  0.1732051
       [73]  0.6928203  0.6928203  0.5196152  0.3464102  0.3464102  0.5196152
       [79]  1.0392305  1.0392305  0.8660254  0.6928203  0.6928203  0.8660254
       [85]  1.3856406  1.3856406  1.2124356  1.0392305  1.0392305  1.2124356
       [91]  0.1732051  0.1732051  0.0000000 -0.1732051 -0.1732051  0.0000000
       [97]  0.5196152  0.5196152  0.3464102  0.1732051  0.1732051  0.3464102
      [103]  0.8660254  0.8660254  0.6928203  0.5196152  0.5196152  0.6928203
      [109]  1.2124356  1.2124356  1.0392305  0.8660254  0.8660254  1.0392305
      [115]  1.5588457  1.5588457  1.3856406  1.2124356  1.2124356  1.3856406
      [121]  0.0000000  0.0000000 -0.1732051 -0.3464102 -0.3464102 -0.1732051
      [127]  0.3464102  0.3464102  0.1732051  0.0000000  0.0000000  0.1732051
      [133]  0.6928203  0.6928203  0.5196152  0.3464102  0.3464102  0.5196152
      [139]  1.0392305  1.0392305  0.8660254  0.6928203  0.6928203  0.8660254
      [145]  1.3856406  1.3856406  1.2124356  1.0392305  1.0392305  1.2124356
      [151]  0.1732051  0.1732051  0.0000000 -0.1732051 -0.1732051  0.0000000
      [157]  0.5196152  0.5196152  0.3464102  0.1732051  0.1732051  0.3464102
      [163]  0.8660254  0.8660254  0.6928203  0.5196152  0.5196152  0.6928203
      [169]  1.2124356  1.2124356  1.0392305  0.8660254  0.8660254  1.0392305
      [175]  1.5588457  1.5588457  1.3856406  1.2124356  1.2124356  1.3856406
      [181]  0.0000000  0.0000000 -0.1732051 -0.3464102 -0.3464102 -0.1732051
      [187]  0.3464102  0.3464102  0.1732051  0.0000000  0.0000000  0.1732051
      [193]  0.6928203  0.6928203  0.5196152  0.3464102  0.3464102  0.5196152
      [199]  1.0392305  1.0392305  0.8660254  0.6928203  0.6928203  0.8660254
      [205]  1.3856406  1.3856406  1.2124356  1.0392305  1.0392305  1.2124356
      [211]  0.1732051  0.1732051  0.0000000 -0.1732051 -0.1732051  0.0000000
      [217]  0.5196152  0.5196152  0.3464102  0.1732051  0.1732051  0.3464102
      [223]  0.8660254  0.8660254  0.6928203  0.5196152  0.5196152  0.6928203
      [229]  1.2124356  1.2124356  1.0392305  0.8660254  0.8660254  1.0392305
      [235]  1.5588457  1.5588457  1.3856406  1.2124356  1.2124356  1.3856406
      
      $hex_poly$y
        [1] -0.05040708 -0.24959292 -0.34918584 -0.24959292 -0.05040708  0.04918584
        [7] -0.05040708 -0.24959292 -0.34918584 -0.24959292 -0.05040708  0.04918584
       [13] -0.05040708 -0.24959292 -0.34918584 -0.24959292 -0.05040708  0.04918584
       [19] -0.05040708 -0.24959292 -0.34918584 -0.24959292 -0.05040708  0.04918584
       [25] -0.05040708 -0.24959292 -0.34918584 -0.24959292 -0.05040708  0.04918584
       [31]  0.24959292  0.05040708 -0.04918584  0.05040708  0.24959292  0.34918584
       [37]  0.24959292  0.05040708 -0.04918584  0.05040708  0.24959292  0.34918584
       [43]  0.24959292  0.05040708 -0.04918584  0.05040708  0.24959292  0.34918584
       [49]  0.24959292  0.05040708 -0.04918584  0.05040708  0.24959292  0.34918584
       [55]  0.24959292  0.05040708 -0.04918584  0.05040708  0.24959292  0.34918584
       [61]  0.54959292  0.35040708  0.25081416  0.35040708  0.54959292  0.64918584
       [67]  0.54959292  0.35040708  0.25081416  0.35040708  0.54959292  0.64918584
       [73]  0.54959292  0.35040708  0.25081416  0.35040708  0.54959292  0.64918584
       [79]  0.54959292  0.35040708  0.25081416  0.35040708  0.54959292  0.64918584
       [85]  0.54959292  0.35040708  0.25081416  0.35040708  0.54959292  0.64918584
       [91]  0.84959292  0.65040708  0.55081416  0.65040708  0.84959292  0.94918584
       [97]  0.84959292  0.65040708  0.55081416  0.65040708  0.84959292  0.94918584
      [103]  0.84959292  0.65040708  0.55081416  0.65040708  0.84959292  0.94918584
      [109]  0.84959292  0.65040708  0.55081416  0.65040708  0.84959292  0.94918584
      [115]  0.84959292  0.65040708  0.55081416  0.65040708  0.84959292  0.94918584
      [121]  1.14959292  0.95040708  0.85081416  0.95040708  1.14959292  1.24918584
      [127]  1.14959292  0.95040708  0.85081416  0.95040708  1.14959292  1.24918584
      [133]  1.14959292  0.95040708  0.85081416  0.95040708  1.14959292  1.24918584
      [139]  1.14959292  0.95040708  0.85081416  0.95040708  1.14959292  1.24918584
      [145]  1.14959292  0.95040708  0.85081416  0.95040708  1.14959292  1.24918584
      [151]  1.44959292  1.25040708  1.15081416  1.25040708  1.44959292  1.54918584
      [157]  1.44959292  1.25040708  1.15081416  1.25040708  1.44959292  1.54918584
      [163]  1.44959292  1.25040708  1.15081416  1.25040708  1.44959292  1.54918584
      [169]  1.44959292  1.25040708  1.15081416  1.25040708  1.44959292  1.54918584
      [175]  1.44959292  1.25040708  1.15081416  1.25040708  1.44959292  1.54918584
      [181]  1.74959292  1.55040708  1.45081416  1.55040708  1.74959292  1.84918584
      [187]  1.74959292  1.55040708  1.45081416  1.55040708  1.74959292  1.84918584
      [193]  1.74959292  1.55040708  1.45081416  1.55040708  1.74959292  1.84918584
      [199]  1.74959292  1.55040708  1.45081416  1.55040708  1.74959292  1.84918584
      [205]  1.74959292  1.55040708  1.45081416  1.55040708  1.74959292  1.84918584
      [211]  2.04959292  1.85040708  1.75081416  1.85040708  2.04959292  2.14918584
      [217]  2.04959292  1.85040708  1.75081416  1.85040708  2.04959292  2.14918584
      [223]  2.04959292  1.85040708  1.75081416  1.85040708  2.04959292  2.14918584
      [229]  2.04959292  1.85040708  1.75081416  1.85040708  2.04959292  2.14918584
      [235]  2.04959292  1.85040708  1.75081416  1.85040708  2.04959292  2.14918584
      
      
      $data_hb_id
      $data_hb_id$UMAP1
       [1] 0.08044271 0.73857864 0.83992020 0.16719939 0.26292782 0.83820653
       [7] 0.73364820 0.62693057 0.80998347 0.90342138 0.64241759 0.05182936
      [13] 0.96228699 0.07223295 0.64916340 0.80783543 0.13518498 0.80668446
      [19] 0.60311661 0.16150976 0.71326033 0.09405763 0.08900367 0.77510396
      [25] 0.79296306 0.28575187 0.46806684 0.57541142 0.21053454 0.62412077
      [31] 0.76738169 0.76427076 0.64842247 0.03170275 0.96450414 0.10117880
      [37] 0.71265285 0.82904448 0.81275032 0.00000000 0.38392618 0.82638316
      [43] 0.29256853 0.84482412 0.79995094 0.69339205 0.13459287 0.04209521
      [49] 0.94245034 0.05349536 0.68677026 0.77828853 0.75504949 0.23125328
      [55] 0.76831122 0.69843891 0.72681720 0.99318862 0.96227596 0.39315580
      [61] 0.74175661 0.94650462 0.50932690 1.00000000 0.33548077 0.25450458
      [67] 0.88588122 0.72192354 0.68029522 0.92537063 0.80964667 0.49582819
      [73] 0.16301062 0.29499615 0.91053035
      
      $data_hb_id$UMAP2
       [1] 0.274498327 0.859778569 0.929412446 0.037066861 0.341734583 1.720961652
       [7] 0.833935370 0.618409921 0.868291303 1.600664528 0.631646064 0.320865388
      [13] 1.546732900 0.218331864 0.593427000 1.374772146 0.335559538 1.381019256
      [19] 0.597381477 0.009905107 0.797282390 0.058760856 0.252258947 1.730112607
      [25] 1.100876246 0.202379969 0.482713207 0.708486670 0.151933039 0.712391079
      [31] 1.018811832 1.552630670 0.661926514 0.303630086 1.665355817 0.050909321
      [37] 1.539719959 1.722765733 1.732050808 0.271778584 0.390190144 1.011632238
      [43] 0.138015108 0.983163036 0.964486583 1.448210796 0.000000000 0.257916294
      [49] 1.680924200 0.187982579 0.778563498 0.839937252 1.670893354 0.061042472
      [55] 1.497157149 1.621642749 0.931757885 1.521102615 1.546125959 0.328235991
      [61] 1.681926517 1.524113512 0.617404710 1.625538768 0.278688714 0.063074584
      [67] 1.408512652 0.952956061 1.508729997 1.455380663 1.529334517 0.604985028
      [73] 0.030266486 0.117297635 1.445460921
      
      $data_hb_id$hb_id
       [1]  6 18 24  2 12 34 18 18 18 34 18 12 34  6 18 28 12 28 13  2 18  6  6 34 24
      [26]  7 13 18  7 18 24 34 18  6 34  6 34 34 34  6 13 24  7 24 24 28  2  6 34  6
      [51] 18 18 34  7 28 34 24 29 34 13 34 34 13 34  7  7 29 24 28 29 34 13  2  7 29
      
      
      $std_cts
      $std_cts$hb_id
       [1]  2  6  7 12 13 18 24 28 29 34
      
      $std_cts$std_counts
       [1] 0.2352941 0.5294118 0.4117647 0.1764706 0.3529412 0.7058824 0.4705882
       [8] 0.2941176 0.2352941 1.0000000
      
      
      $tot_bins
      [1] 40
      
      $non_bins
      [1] 10
      
      $pts_bins
      $pts_bins$hexID
       [1]  6 18 24  2 12 34 28 13  7 29
      
      $pts_bins$pts_list
      $pts_bins$pts_list$`Points in hexID: 6`
       [1]   1   2   3   4   6   7   8   9  11  12  14  15  16  17  19  20  21  22  23
      [20]  24  25  26  31  33  34  35  37  38  39  40  41  42  43  44  45  46  47  51
      [39]  52  54  55  56  57  59  60  62  63  64  65  66  67  69  70  71  72  73  74
      [58]  75  76  77  78  79  80  81  84  87  89  91  93  94  95  96  97  99 100
      
      $pts_bins$pts_list$`Points in hexID: 18`
       [1]   1   2   3   4   6   7   8   9  11  12  14  15  16  17  19  20  21  22  23
      [20]  24  25  26  31  33  34  35  37  38  39  40  41  42  43  44  45  46  47  51
      [39]  52  54  55  56  57  59  60  62  63  64  65  66  67  69  70  71  72  73  74
      [58]  75  76  77  78  79  80  81  84  87  89  91  93  94  95  96  97  99 100
      
      $pts_bins$pts_list$`Points in hexID: 24`
       [1]   1   2   3   4   6   7   8   9  11  12  14  15  16  17  19  20  21  22  23
      [20]  24  25  26  31  33  34  35  37  38  39  40  41  42  43  44  45  46  47  51
      [39]  52  54  55  56  57  59  60  62  63  64  65  66  67  69  70  71  72  73  74
      [58]  75  76  77  78  79  80  81  84  87  89  91  93  94  95  96  97  99 100
      
      $pts_bins$pts_list$`Points in hexID: 2`
       [1]   1   2   3   4   6   7   8   9  11  12  14  15  16  17  19  20  21  22  23
      [20]  24  25  26  31  33  34  35  37  38  39  40  41  42  43  44  45  46  47  51
      [39]  52  54  55  56  57  59  60  62  63  64  65  66  67  69  70  71  72  73  74
      [58]  75  76  77  78  79  80  81  84  87  89  91  93  94  95  96  97  99 100
      
      $pts_bins$pts_list$`Points in hexID: 12`
       [1]   1   2   3   4   6   7   8   9  11  12  14  15  16  17  19  20  21  22  23
      [20]  24  25  26  31  33  34  35  37  38  39  40  41  42  43  44  45  46  47  51
      [39]  52  54  55  56  57  59  60  62  63  64  65  66  67  69  70  71  72  73  74
      [58]  75  76  77  78  79  80  81  84  87  89  91  93  94  95  96  97  99 100
      
      $pts_bins$pts_list$`Points in hexID: 34`
       [1]   1   2   3   4   6   7   8   9  11  12  14  15  16  17  19  20  21  22  23
      [20]  24  25  26  31  33  34  35  37  38  39  40  41  42  43  44  45  46  47  51
      [39]  52  54  55  56  57  59  60  62  63  64  65  66  67  69  70  71  72  73  74
      [58]  75  76  77  78  79  80  81  84  87  89  91  93  94  95  96  97  99 100
      
      $pts_bins$pts_list$`Points in hexID: 28`
       [1]   1   2   3   4   6   7   8   9  11  12  14  15  16  17  19  20  21  22  23
      [20]  24  25  26  31  33  34  35  37  38  39  40  41  42  43  44  45  46  47  51
      [39]  52  54  55  56  57  59  60  62  63  64  65  66  67  69  70  71  72  73  74
      [58]  75  76  77  78  79  80  81  84  87  89  91  93  94  95  96  97  99 100
      
      $pts_bins$pts_list$`Points in hexID: 13`
       [1]   1   2   3   4   6   7   8   9  11  12  14  15  16  17  19  20  21  22  23
      [20]  24  25  26  31  33  34  35  37  38  39  40  41  42  43  44  45  46  47  51
      [39]  52  54  55  56  57  59  60  62  63  64  65  66  67  69  70  71  72  73  74
      [58]  75  76  77  78  79  80  81  84  87  89  91  93  94  95  96  97  99 100
      
      $pts_bins$pts_list$`Points in hexID: 7`
       [1]   1   2   3   4   6   7   8   9  11  12  14  15  16  17  19  20  21  22  23
      [20]  24  25  26  31  33  34  35  37  38  39  40  41  42  43  44  45  46  47  51
      [39]  52  54  55  56  57  59  60  62  63  64  65  66  67  69  70  71  72  73  74
      [58]  75  76  77  78  79  80  81  84  87  89  91  93  94  95  96  97  99 100
      
      $pts_bins$pts_list$`Points in hexID: 29`
       [1]   1   2   3   4   6   7   8   9  11  12  14  15  16  17  19  20  21  22  23
      [20]  24  25  26  31  33  34  35  37  38  39  40  41  42  43  44  45  46  47  51
      [39]  52  54  55  56  57  59  60  62  63  64  65  66  67  69  70  71  72  73  74
      [58]  75  76  77  78  79  80  81  84  87  89  91  93  94  95  96  97  99 100
      
      
      

# find_non_empty_bins() works

    Code
      suppressMessages(find_non_empty_bins(data = s_curve_noise_umap_scaled, x = "UMAP1",
        y = "UMAP2", non_empty_bins = 10, x_start = NA, y_start = NA, buffer_x = NA,
        buffer_y = NA, hex_size = NA, col_start = "UMAP"))
    Output
      $num_bins_x
      [1] 3
      
      $num_bins_y
      [1] 8
      

# extract_hexbin_centroids() works

    Code
      extract_hexbin_centroids(centroids_df = all_centroids_df, counts_df = counts_df)
    Output
         hexID       c_x   c_y std_counts
      1      2 0.1732051 -0.15  0.2352941
      2      6 0.0000000  0.15  0.5294118
      3      7 0.3464102  0.15  0.4117647
      4     12 0.1732051  0.45  0.1764706
      5     13 0.5196152  0.45  0.3529412
      6     18 0.6928203  0.75  0.7058824
      7     24 0.8660254  1.05  0.4705882
      8     28 0.6928203  1.35  0.2941176
      9     29 1.0392305  1.35  0.2352941
      10    34 0.8660254  1.65  1.0000000

# tri_bin_centroids() works

    Code
      suppressWarnings(tri_bin_centroids(hex_df = df_bin_centroids, x = "c_x", y = "c_y"))
    Output
      Delaunay triangulation, node and triangle indices:
      triangle: nodes (a,b,c), neighbour triangles [i,j,k] 
      1: (1,3,2), [2,0,4]
      2: (4,2,3), [1,3,9]
      3: (5,4,3), [2,4,5]
      4: (5,3,1), [1,8,3]
      5: (6,4,5), [3,7,10]
      6: (6,7,8), [11,10,7]
      7: (7,6,5), [5,8,6]
      8: (7,1,5), [4,7,0]
      9: (8,4,2), [2,0,10]
      10: (6,8,4), [9,5,6]
      11: (9,8,7), [6,0,12]
      12: (10,8,9), [11,0,0]
      boundary nodes:  2 1 7 9 10 8 

# gen_edges() works

    Code
      gen_edges(tri_object = tr1_object)
    Output
      # A tibble: 21 x 6
          from    to x_from y_from  x_to  y_to
         <int> <int>  <dbl>  <dbl> <dbl> <dbl>
       1     1     3  0.173  -0.15 0.346  0.15
       2     2     4  0       0.15 0.173  0.45
       3     4     5  0.173   0.45 0.520  0.45
       4     3     5  0.346   0.15 0.520  0.45
       5     4     6  0.173   0.45 0.693  0.75
       6     6     7  0.693   0.75 0.866  1.05
       7     1     7  0.173  -0.15 0.866  1.05
       8     4     8  0.173   0.45 0.693  1.35
       9     6     8  0.693   0.75 0.693  1.35
      10     8     9  0.693   1.35 1.04   1.35
      # i 11 more rows

# cal_2d_dist() works

    Code
      cal_2d_dist(tr_coord_df = tr_from_to_df, start_x = "x_from", start_y = "y_from",
        end_x = "x_to", end_y = "y_to", select_vars = c("from", "to", "distance"))
    Output
      # A tibble: 21 x 3
          from    to distance
         <int> <int>    <dbl>
       1     1     3    0.346
       2     2     4    0.346
       3     4     5    0.346
       4     3     5    0.346
       5     4     6    0.6  
       6     6     7    0.346
       7     1     7    1.39 
       8     4     8    1.04 
       9     6     8    0.6  
      10     8     9    0.346
      # i 11 more rows

