% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/func_chain.R
\name{\%.\%}
\alias{\%.\%}
\alias{chain_sep}
\title{simple function chaining routine}
\usage{
obj \%.\% funcs

chain_sep(sep = "\\\\.\\\\.")
}
\arguments{
\item{obj}{data object to apply function}

\item{funcs}{function chains to apply to the data object}

\item{sep}{separated for funcs argument values}
}
\value{
the result of applying the chained functions to the data object
}
\description{
chain multiple function to a call
}
\note{
chain_sep allows the user to preset the separator for the function chaining \cr\cr
e.g. you can call the function to set sep = "__" before using the %.% call to parse the chained function "__unique__sum"
}
\examples{
#use defult sep ".."
1:3\%.\%unique..length
sample(1:1000,10,replace=TRUE) \%.\%unique..length
sample(1:10,10,replace=TRUE) \%.\%unique..cumsum

# set sep before function chaining
chain_sep("__")
sample(1:10,10,replace=TRUE) \%.\%unique__cumsum
sample(1:10,10,replace=TRUE) \%.\%unique__cumsum__length

}
