% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/any.R
\name{any_flat_homogeneous_list}
\alias{any_flat_homogeneous_list}
\title{Any flat homogeneous list generator}
\usage{
any_flat_homogeneous_list(len = c(1L, 10L), any_na = FALSE)
}
\arguments{
\item{len}{Length of the generated vectors. If \code{len} is a
single number all vectors will have this length. If
\code{len} is a numeric vector of length 2 it will produce
vectors with lengths between a minimum and maximum,
inclusive. For example \code{len = c(1L, 10L)} would produce
vectors with lengths between 1 and 10. To produce empty vectors
set \code{len = 0L} or a range like \code{len = c(0L, 10L)}.}

\item{any_na}{Whether \code{NA} values should be allowed.}
}
\value{
A \code{quickcheck_generator} object.
}
\description{
Generate lists in which each element is an atomic scalar of the same class.
}
\examples{
any_flat_homogeneous_list() |> show_example()
any_flat_homogeneous_list(len = 10L, any_na = TRUE) |> show_example()
}
