% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quest_functions.R
\name{winsor}
\alias{winsor}
\title{Winsorize a Numeric Vector}
\usage{
winsor(x, z.min = -3, z.max = 3, rtn.int = FALSE, to.na = FALSE)
}
\arguments{
\item{x}{numeric vector}

\item{z.min}{numeric vector of length 1 specifying the lower boundary value
in z-score units.}

\item{z.max}{numeric vector of length 1 specifying the upper boundary value
in z-score units.}

\item{rtn.int}{logical vector of length 1 specifying whether the recoded values
should be rounded to the nearest integer. This can be useful when working with
count data and decimal values are impossible.}

\item{to.na}{logical vector of length 1 specifying whether the extreme values
should be recoded to NA rather than winsorized to the boundary values.}
}
\value{
numeric vector of the same length as \code{x} with extreme values
recoded as either the boundary values or NA.
}
\description{
\code{winsor} winsorizes a numeric vector by recoding extreme values as a user-identified boundary value, which is defined by z-score units. The \code{to.na}
argument provides the option of recoding the extreme values as missing.
}
\details{
Note, the psych package also has a function called \code{winsor}, which offers
the option to winsorize a numeric vector by quantiles rather than z-scores. If you have both the quest package and the psych
package attached in your current R session (e.g., using \code{library}),
depending on which package you attached first, R might default to using the
\code{winsor} function in either the quest package or the psych package. One
way to deal with this issue is to explicitly call which package you want to
use the \code{winsor} package from. You can do this using the \code{::}
function in base R where the package name comes before the \code{::} and the
function names comes after it (e.g., \code{quest::winsor}).
}
\examples{

# winsorize
table(quakes$"stations")
new <- winsor(quakes$"stations")
table(new)

# recode as NA
vecNA(quakes$"stations")
new <- winsor(quakes$"stations", to.na = TRUE)
vecNA(new)

# rtn.int = TRUE
winsor(x = cars[[1]], z.min = -2, z.max = 2, rtn.int = FALSE)
winsor(x = cars[[1]], z.min = -2, z.max = 2, rtn.int = TRUE)
}
\seealso{
\code{\link{winsors}}
   \code{\link[psych]{winsor}} # psych package
}
