% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quest_functions.R
\name{shift_by}
\alias{shift_by}
\title{Shift a Vector (i.e., lag/lead) by Group}
\usage{
shift_by(x, grp, n, undefined = NA)
}
\arguments{
\item{x}{atomic vector or list vector.}

\item{grp}{list of atomic vector(s) and/or factor(s) (e.g., data.frame),
which each have same length as \code{x}. It can also be an atomic vector or
factor, which will then be made the first element of a list internally.}

\item{n}{integer vector with length 1. Specifies the direction and magnitude
of the shift. See details.}

\item{undefined}{atomic vector with length 1 (probably makes sense to be the
same typeof as \code{x}). Specifies what to insert for undefined values
after the shifting takes place. See details.}
}
\value{
an atomic vector of the same length as \code{x} that is shifted by
  group. If \code{x} and \code{undefined} are different typeofs, then the
  return will be coerced to the most complex typeof (i.e., complex to simple:
  character, double, integer, logical).
}
\description{
\code{shift_by} shifts elements of a vector right (\code{n} < 0) for lags or
left (\code{n} > 0) for leads by group, replacing the undefined data with a
user-defined value (e.g., NA). The number of elements shifted is equal to
\code{abs(n)}. It is assumed that \code{x} is already sorted within each
group by time such that the first element for that group is earliest in time
and the last element for that group is the latest in time.
}
\details{
If \code{n} is negative, then \code{shift_by} inserts \code{undefined} into the
first \code{abs(n)} elements of \code{x} for each group, shifting all other
values of \code{x} to the right \code{abs(n)} positions, and then dropping
the last \code{abs(n)} elements of \code{x} to preserve the original length
of each group. If \code{n} is positive, then \code{shift_by} drops the first
\code{abs(n)} elements of \code{x} for each group, shifting all other values
of \code{x} left \code{abs(n)} positions, and then inserts \code{undefined}
into the last \code{abs(n)} elements of \code{x} to preserve the original
length of each group. If \code{n} is zero, then \code{shift_by} simply returns
\code{x}.

It is recommended to use \code{L} when specifying \code{n} to prevent
problems with floating point numbers. \code{shift_by} tries to circumvent this
issue by a call to \code{round} within \code{shift_by} if \code{n} is not an
integer; however that is not a complete fail safe. The problem is that
\code{as.integer(n)} implicit in \code{shift_by} truncates rather than rounds.
}
\examples{
shift_by(x = ChickWeight[["Time"]], grp = ChickWeight[["Chick"]], n = -1L)
tmp_nm <- c("vs","am") # b/c Roxygen2 doesn't like c() in a []
shift_by(x = mtcars[["disp"]], grp = mtcars[tmp_nm], n = 1L)
tmp_nm <- c("Type","Treatment") # b/c Roxygen2 doesn't like c() in a []
shift_by(x = as.data.frame(CO2)[["uptake"]], grp = as.data.frame(CO2)[tmp_nm],
   n = 2L) # multiple grouping vectors
}
\seealso{
\code{\link{shifts_by}}
   \code{\link{shift}}
   \code{\link{shifts}}
}
