% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/serve.R
\name{quarto_serve}
\alias{quarto_serve}
\alias{quarto_serve_stop}
\title{Quarto Development Server}
\usage{
quarto_serve(
  dir = NULL,
  render = "none",
  port = "auto",
  host = "127.0.0.1",
  browse = TRUE,
  watch = TRUE,
  navigate = TRUE
)

quarto_serve_stop()
}
\arguments{
\item{dir}{The project directory to serve (defaults to current working
directory)}

\item{render}{By default, the most recent execution results of computational
documents are used to render the site (this is to optimize start up time).
If you want to perform a full render prior to serving pass "all" or a
vector of specific formats to render. Pass "default" to render the default
format for the site.}

\item{port}{Port to listen on (defaults to 4848)}

\item{host}{Hostname to bind to (defaults to 127.0.0.1)}

\item{browse}{Open a browser to preview the content. Defaults to using the
RStudio Viewer when running within RStudio.Pass a function (e.g.
\code{utils::browseURL} to override this behavior).}

\item{watch}{Watch for changes and automatically reload browser.}

\item{navigate}{Automatically navivate the preview browser to the most
recently rendered document.}
}
\description{
Run a local web server for a Quarto project.
}
\examples{
\dontrun{
# Run a local server for the project in the current directory
quarto_serve()

# Run server for project in "myproj" directory and preview in external
# browser (rather than RStudio Viewer)
quarto_serve("myproj", open = utils::browseURL)

# Stop any running quarto server
quarto_serve_stop()
}

}
