% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/anscombe_quartet.R
\docType{data}
\name{anscombe_quartet}
\alias{anscombe_quartet}
\title{Anscombe's Quartet Data}
\format{
A dataframe with 44 rows and 3 variables:
\itemize{
\item \code{dataset}: the dataset the values come from
\item \code{x}: the x-variable
\item \code{y}: the y-variable
}
}
\usage{
anscombe_quartet
}
\description{
This dataset contains 44 observations, 11 observations from 4 datasets
generated by Francis Anscombe to demonstrate that statistical summary
measures alone cannot capture the full relationship between two variables
(here, \code{x} and \code{y}). Anscombe emphasized the importance of visualizing data
prior to calculating summary statistics.
}
\details{
\itemize{
\item Dataset 1 has a linear relationship between \code{x} and \code{y}
\item Dataset 2 has shows a nonlinear relationship between \code{x} and \code{y}
\item Dataset 3 has a linear relationship between \code{x} and \code{y} with a single outlier
\item Dataset 4 has shows no relationship between \code{x} and \code{y} with a single
outlier that serves as a high-leverage point.
}

In each of the datasets the following statistical summaries hold:
\itemize{
\item mean of \code{x}: 9
\item variance of \code{x}: 11
\item mean of \code{y}: 7.5
\item variance of y: 4.125
\item correlation between \code{x} and \code{y}: 0.816
\item linear regression between \code{x} and \code{y}: \verb{y = 3 + 0.5x}
\item \eqn{R^2} for the regression: 0.67
}
}
\references{
Anscombe, F. J. (1973). "Graphs in Statistical Analysis".
American Statistician. 27 (1): 17–21. doi:10.1080/00031305.1973.10478966.
JSTOR 2682899.
}
\keyword{datasets}
