% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/Class-KernelWeight.R
\name{KernelWeight-constructor}
\alias{KernelWeight-constructor}
\alias{kernelWeight}
\title{Create an instance of the \code{\link{KernelWeight}} class.}
\usage{
kernelWeight(W = W0, N = 1, bw = 0.1 * N^(-1/5), descr = paste("bw=",
  round(bw, 3), ", N=", N, sep = ""))
}
\arguments{
\item{W}{A kernel function}

\item{N}{Fourier basis; number of grid points in \eqn{[0,2\pi)}{[0,2pi)} for
which the weights will be computed.}

\item{bw}{bandwidth; if a vector, then a list of weights is returned}

\item{descr}{a description to be used in some plots}
}
\value{
Returns an instance of \code{KernelWeight}.
}
\description{
Create an instance of the \code{\link{KernelWeight}} class.
}
\examples{
wgt1 <- kernelWeight(W=W0, N=16, bw=c(0.1,0.3,0.7))
print(wgt1)
wgt2 <- kernelWeight(W=W1, N=2^8, bw=0.1)
plot(wgt2, main="Weights determined from Epanechnikov kernel")
}
\seealso{
\code{\link{kernels}}
}
\keyword{Constructors}

