% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tokens_chunk.R
\name{tokens_chunk}
\alias{tokens_chunk}
\title{Segment tokens object by chunks of a given size}
\usage{
tokens_chunk(
  x,
  size,
  overlap = 0,
  use_docvars = TRUE,
  verbose = quanteda_options("verbose")
)
}
\arguments{
\item{x}{\link{tokens} object whose token elements will be segmented into
chunks}

\item{size}{integer; the token length of the chunks}

\item{overlap}{integer; the number of tokens in a chunk to be taken from the
last \code{overlap} tokens from the preceding chunk}

\item{use_docvars}{if \code{TRUE}, repeat the docvar values for each chunk;
if \code{FALSE}, drop the docvars in the chunked tokens}

\item{verbose}{if \code{TRUE} print the number of tokens and documents before and
after the function is applied. The number of tokens does not include paddings.}
}
\value{
A \link{tokens} object whose documents have been split into chunks of
length \code{size}.
}
\description{
Segment tokens into new documents of equally sized token lengths, with the
possibility of overlapping the chunks.
}
\examples{
txts <- c(doc1 = "Fellow citizens, I am again called upon by the voice of
                  my country to execute the functions of its Chief Magistrate.",
          doc2 = "When the occasion proper for it shall arrive, I shall
                  endeavor to express the high sense I entertain of this
                  distinguished honor.")
toks <- tokens(txts)
tokens_chunk(toks, size = 5)
tokens_chunk(toks, size = 5, overlap = 4)
}
\seealso{
\code{\link[=tokens_segment]{tokens_segment()}}
}
\keyword{tokens}
