% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/corpus.R
\name{corpus}
\alias{corpus}
\alias{corpus.corpus}
\alias{corpus.character}
\alias{corpus.data.frame}
\alias{corpus.kwic}
\alias{corpus.Corpus}
\title{Construct a corpus object}
\usage{
corpus(x, ...)

\method{corpus}{corpus}(
  x,
  docnames = quanteda::docnames(x),
  docvars = quanteda::docvars(x),
  meta = quanteda::meta(x),
  ...
)

\method{corpus}{character}(
  x,
  docnames = NULL,
  docvars = NULL,
  meta = list(),
  unique_docnames = TRUE,
  ...
)

\method{corpus}{data.frame}(
  x,
  docid_field = "doc_id",
  text_field = "text",
  meta = list(),
  unique_docnames = TRUE,
  ...
)

\method{corpus}{kwic}(x, split_context = TRUE, extract_keyword = TRUE, meta = list(), ...)

\method{corpus}{Corpus}(x, ...)
}
\arguments{
\item{x}{a valid corpus source object}

\item{...}{not used directly}

\item{docnames}{Names to be assigned to the texts.  Defaults to the names of
the character vector (if any); \code{doc_id} for a data.frame; the document
names in a \pkg{tm} corpus; or a vector of user-supplied labels equal in
length to the number of documents.  If none of these are round, then
"text1", "text2", etc. are assigned automatically.}

\item{docvars}{a data.frame of document-level variables associated with each
text}

\item{meta}{a named list that will be added to the corpus as corpus-level,
user meta-data.  This can later be accessed or updated using
\code{\link[=meta]{meta()}}.}

\item{unique_docnames}{logical; if \code{TRUE}, enforce strict uniqueness in
\code{docnames}; otherwise, rename duplicated docnames using an added serial
number, and treat them as segments of the same document.}

\item{docid_field}{optional column index of a document identifier; defaults
to "doc_id", but if this is not found, then will use the rownames of the
data.frame; if the rownames are not set, it will use the default sequence
based on \verb{([quanteda_options]("base_docname")}.}

\item{text_field}{the character name or numeric index of the source
\code{data.frame} indicating the variable to be read in as text, which must
be a character vector. All other variables in the data.frame will be
imported as docvars.  This argument is only used for \code{data.frame}
objects (including those created by \pkg{readtext}).}

\item{split_context}{logical; if \code{TRUE}, split each kwic row into two
"documents", one for "pre" and one for "post", with this designation saved
in a new docvar \code{context} and with the new number of documents
therefore being twice the number of rows in the kwic.}

\item{extract_keyword}{logical; if  \code{TRUE}, save the keyword matching
\code{pattern} as a new docvar \code{keyword}}
}
\value{
A \linkS4class{corpus} class object containing the original texts,
document-level variables, document-level metadata, corpus-level metadata,
and default settings for subsequent processing of the corpus.

For \pkg{quanteda} >= 2.0, this is a specially classed character vector. It
has many additional attributes but \strong{you should not access these
attributes directly}, especially if you are another package author. Use the
extractor and replacement functions instead, or else your code is not only
going to be uglier, but also likely to break should the internal structure
of a corpus object change.  Using the accessor and replacement functions
ensures that future code to manipulate corpus objects will continue to work.
}
\description{
Creates a corpus object from available sources.  The currently available
sources are:
\itemize{
\item a \link{character} vector, consisting of one document per
element; if the elements are named, these names will be used as document
names.
\item a \link{data.frame} (or a \pkg{tibble} \code{tbl_df}), whose default
document id is a variable identified by \code{docid_field}; the text of the
document is a variable identified by \code{text_field}; and other variables
are imported as document-level meta-data.  This matches the format of
data.frames constructed by the the \pkg{readtext} package.
\item a \link{kwic} object constructed by \code{\link[=kwic]{kwic()}}.
\item a \pkg{tm} \link[tm:VCorpus]{VCorpus} or \link[tm:SimpleCorpus]{SimpleCorpus} class  object,
with the fixed metadata
fields imported as \link{docvars} and corpus-level metadata imported
as \link{metacorpus} information.
\item a \link{corpus} object.
}
}
\details{
The texts and document variables of corpus objects can also be
accessed using index notation and the \code{$} operator for accessing or assigning
docvars.  For details, see \code{\link[=corpus-class]{[.corpus()}}.
}
\examples{
# create a corpus from texts
corpus(data_char_ukimmig2010)

# create a corpus from texts and assign meta-data and document variables
summary(corpus(data_char_ukimmig2010,
               docvars = data.frame(party = names(data_char_ukimmig2010))), 5)

# import a tm VCorpus
if (requireNamespace("tm", quietly = TRUE)) {
    data(crude, package = "tm")    # load in a tm example VCorpus
    vcorp <- corpus(crude)
    summary(vcorp)

    data(acq, package = "tm")
    summary(corpus(acq), 5)

    vcorp2 <- tm::VCorpus(tm::VectorSource(data_char_ukimmig2010))
    corp <- corpus(vcorp2)
    summary(corp)
}

# construct a corpus from a data.frame
dat <- data.frame(letter_factor = factor(rep(letters[1:3], each = 2)),
                  some_ints = 1L:6L,
                  some_text = paste0("This is text number ", 1:6, "."),
                  stringsAsFactors = FALSE,
                  row.names = paste0("fromDf_", 1:6))
dat
summary(corpus(dat, text_field = "some_text",
               meta = list(source = "From a data.frame called mydf.")))

# construct a corpus from a kwic object
kw <- kwic(data_corpus_inaugural, "southern")
summary(corpus(kw))
# from a kwic
kw <- kwic(data_char_sampletext, "econom*", separator = "",
           remove_separators = FALSE) # keep original separators
summary(corpus(kw))
summary(corpus(kw, split_context = FALSE))
texts(corpus(kw, split_context = FALSE))

}
\seealso{
\linkS4class{corpus}, \code{\link[=docvars]{docvars()}},
\code{\link[=meta]{meta()}}, \code{\link[=texts]{texts()}}, \code{\link[=ndoc]{ndoc()}},
\code{\link[=docnames]{docnames()}}
}
\keyword{corpus}
