% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/corpus-methods-base.R
\name{corpus-class}
\alias{corpus-class}
\alias{is.corpus}
\alias{print.summary.corpus}
\alias{+.corpus}
\alias{c.corpus}
\alias{[.corpus}
\title{Base method extensions for corpus objects}
\usage{
is.corpus(x)

\method{print}{summary.corpus}(x, ...)

\method{+}{corpus}(c1, c2)

\method{c}{corpus}(..., recursive = FALSE)

\method{[}{corpus}(x, i)
}
\arguments{
\item{x}{a corpus object}

\item{c1}{corpus one to be added}

\item{c2}{corpus two to be added}

\item{recursive}{logical used by \code{c()} method, always set to \code{FALSE}}

\item{i}{index for documents or rows of document variables}

\item{j}{index for column of document variables}

\item{drop}{if \code{TRUE}, return a vector if extracting a single document
variable; if \code{FALSE}, return it as a single-column data.frame.  See
\code{\link[=drop]{drop()}} for further details.}
}
\value{
\code{is.corpus} returns \code{TRUE} if the object is a corpus

The \code{+} and \code{c()} operators return a \code{\link[=corpus]{corpus()}} object.

Indexing a corpus works in three ways, as of v2.x.x:
\itemize{
\item \code{[} returns a subsetted corpus
\item \code{[[} returns the textual contents of a subsetted corpus (similar to \code{\link[=texts]{texts()}})
\item \code{$} returns a vector containing the single named \link{docvars}
}
}
\description{
Extensions of base R functions for corpus objects.
}
\details{
The \code{+} operator for a corpus object will combine two corpus
objects, resolving any non-matching \code{\link[=docvars]{docvars()}} by making them
into \code{NA} values for the corpus lacking that field. Corpus-level meta
data is concatenated, except for \code{source} and \code{notes}, which are
stamped with information pertaining to the creation of the new joined
corpus.

The \code{c()} operator is also defined for corpus class objects, and provides
an easy way to combine multiple corpus objects.

There are some issues that need to be addressed in future revisions of
quanteda concerning the use of factors to store document variables and
meta-data.  Currently most or all of these are not recorded as factors,
because we use \code{stringsAsFactors=FALSE} in the
\code{\link[=data.frame]{data.frame()}} calls that are used to create and store the
document-level information, because the texts should always be stored as
character vectors and never as factors.
}
\examples{
# concatenate corpus objects
corp1 <- corpus(data_char_ukimmig2010[1:2])
corp2 <- corpus(data_char_ukimmig2010[3:4])
corp3 <- corpus(data_char_ukimmig2010[5:6])
summary(c(corp1, corp2, corp3))

# two ways to index corpus elements
data_corpus_inaugural["1793-Washington"]
data_corpus_inaugural[2]

# return the text itself
data_corpus_inaugural[["1793-Washington"]]
}
\seealso{
\code{\link[=summary.corpus]{summary.corpus()}}
}
\keyword{corpus}
\keyword{internal}
