% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/textplot_wordcloud.R
\name{textplot_wordcloud}
\alias{textplot_wordcloud}
\title{Plot features as a wordcloud}
\usage{
textplot_wordcloud(x, comparison = FALSE, ...)
}
\arguments{
\item{x}{a dfm object}

\item{comparison}{if \code{TRUE}, plot a 
\code{\link[wordcloud]{comparison.cloud}} instead of a simple wordcloud, 
one grouping per document}

\item{...}{additional parameters passed to \link[wordcloud]{wordcloud} or 
to \link{text} (and \link{strheight}, \link{strwidth})}
}
\description{
Plot a \link{dfm} or \link{tokens} object as a wordcloud, where the feature 
labels are plotted with their sizes proportional to their numerical values in
the dfm.  When \code{comparison = TRUE}, it plots comparison word clouds by 
document.
}
\details{
The default is to plot the word cloud of all features, summed across
  documents.  To produce word cloud plots for specific document or set of 
  documents, you need to slice out the document(s) from the dfm or tokens
  object.
  
  Comparison wordcloud plots may be plotted by setting \code{comparison =
  TRUE}, which plots a separate grouping for \emph{each document} in the dfm.
  This means that you will need to slice out just a few documents from the
  dfm, or to create a dfm where the "documents" represent a subset or a
  grouping of documents by some document variable.
}
\examples{
# plot the features (without stopwords) from Obama's two inaugural addresses
mydfm <- dfm(corpus_subset(data_corpus_inaugural, President == "Obama"), 
             remove = stopwords("english"), remove_punct = TRUE)
textplot_wordcloud(mydfm)

# plot in colors with some additional options passed to wordcloud
textplot_wordcloud(mydfm, random.color = TRUE, rot.per = .25, 
                   colors = sample(colors()[2:128], 5))

\dontrun{
# comparison plot of Irish government vs opposition
docvars(data_corpus_irishbudget2010, "govtopp") <- 
    factor(ifelse(data_corpus_irishbudget2010[, "party"] \%in\% c("FF", "Green"), "Govt", "Opp"))
govtoppDfm <- dfm(data_corpus_irishbudget2010, groups = "govtopp", remove_punct = TRUE)
textplot_wordcloud(dfm_tfidf(govtoppDfm), comparison = TRUE)
# compare to non-tf-idf version
textplot_wordcloud(govtoppDfm, comparison = TRUE)
}
}
\seealso{
\code{\link[wordcloud]{wordcloud}}, 
  \code{\link[wordcloud]{comparison.cloud}}
}
\keyword{textplot}
