% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dfm-deprecated.R
\name{compress}
\alias{compress}
\alias{compress.dfm}
\title{compress a dfm by combining similarly named dimensions}
\usage{
compress(x, ...)

\method{compress}{dfm}(x, margin = c("both", "documents", "features"), ...)
}
\arguments{
\item{x}{input object, a \link{dfm}}

\item{...}{additional arguments passed from generic to specific methods}

\item{margin}{character indicating which margin to compress on, either
\code{"documents"}, \code{"features"}, or \code{"both"} (default)}
}
\description{
"Compresses" a dfm whose dimension names are the same, for either documents 
or features.  This may happen, for instance, if features are made equivalent 
through application of a thesaurus.  It may also occur after lower-casing or 
stemming the features of a dfm, but this should only be done in very rare 
cases (approaching never: it's better to do this \emph{before} constructing 
the dfm.)  It could also be needed , after a \code{\link{cbind.dfm}} or 
\code{\link{rbind.dfm}} operation.
}
\note{
This function is deprecated: use \code{\link{dfm_compress}} instead.
}
\examples{
\dontrun{
mat <- rbind(dfm(c("b A A", "C C a b B"), tolower = FALSE, verbose = FALSE),
             dfm("A C C C C C", tolower = FALSE, verbose = FALSE))
colnames(mat) <- char_tolower(featnames(mat))
mat
compress(mat, margin = "documents")
compress(mat, margin = "features")
compress(mat)

# no effect if no compression needed
compress(dfm(data_corpus_inaugural, verbose = FALSE))
}
}
\keyword{deprecated}
\keyword{internal}
