% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nfunctions.R
\name{ndoc}
\alias{ndoc}
\alias{nfeature}
\title{count the number of documents or features}
\usage{
ndoc(x)

nfeature(x)
}
\arguments{
\item{x}{a \pkg{quanteda} object: a \link{corpus}, \link{dfm}, or
\link{tokens} object, or a readtext object from the \pkg{readtext} package.}
}
\value{
an integer (count) of the number of documents or features
}
\description{
Get the number of documents or features in an object.
}
\details{
\code{ndoc} returns the number of documents in a  \link{corpus},
  \link{dfm}, or \link{tokens} object, or a readtext object from the
  \pkg{readtext} package
  
  \code{nfeature} returns the number of features in a \link{dfm}

\code{nfeature} returns the number of features from a dfm; it is an
  alias for \code{ntype} when applied to dfm objects.  This function is only 
  defined for \link{dfm} objects because only these have "features".  (To count
  tokens, see \code{\link{ntoken}}.)
}
\examples{
# number of documents
ndoc(data_corpus_inaugural)
ndoc(corpus_subset(data_corpus_inaugural, Year > 1980))
ndoc(tokens(data_corpus_inaugural))
ndoc(dfm(corpus_subset(data_corpus_inaugural, Year > 1980)))

# number of features
nfeature(dfm(corpus_subset(data_corpus_inaugural, Year > 1980), remove_punct = FALSE))
nfeature(dfm(corpus_subset(data_corpus_inaugural, Year > 1980), remove_punct = TRUE))
}
\seealso{
\code{\link{ntoken}}
}
