% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/settings.R
\name{settings}
\alias{settings}
\alias{settings.corpus}
\alias{settings.default}
\alias{settings.dfm}
\alias{settings<-}
\title{Get or set the corpus settings}
\usage{
settings(x, ...)

\method{settings}{default}(x = NULL, ...)

\method{settings}{corpus}(x, field = NULL, ...)

settings(x, field) <- value

\method{settings}{dfm}(x, ...)
}
\arguments{
\item{x}{object from/to which settings are queried or applied}

\item{...}{additional arguments}

\item{field}{string containing the name of the setting to be set or queried
\code{settings(x)}  query the corps settings 

\code{settings(x, field) <-}  update the corpus settings for \code{field}}

\item{value}{new setting value}
}
\description{
Get or set the corpus settings

Get or set various settings in the corpus for the treatment of texts, such as rules for 
stemming, stopwords, collocations, etc.

Get the settings from a which a \link{dfm} was created
}
\details{
Calling \code{settings()} with no arguments returns a list of system default settings.
}
\examples{
settings(data_corpus_inaugural, "stopwords")
(tempdfm <- dfm(corpus_subset(data_corpus_inaugural, Year>1980), verbose=FALSE))
(tempdfmSW <- dfm(corpus_subset(data_corpus_inaugural, Year>1980),
                 remove = stopwords("english"), verbose=FALSE))
settings(data_corpus_inaugural, "stopwords") <- TRUE
tempdfm <- dfm(data_corpus_inaugural, stem=TRUE, verbose=FALSE)
settings(tempdfm)
}
\keyword{internal}
\keyword{settings}

