% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qualtRicsConfigFile.R
\name{qualtRicsConfigFile}
\alias{qualtRicsConfigFile}
\title{Prints an example of a qualtRics configuration file to the console.}
\usage{
qualtRicsConfigFile(api_token = NULL, root_url = NULL, verbose = TRUE,
  useLabels = TRUE, convertStandardColumns = TRUE, useLocalTime = FALSE,
  dateWarning = TRUE)
}
\arguments{
\item{api_token}{String. API token. Available in your qualtrics account (see: \url{https://api.qualtrics.com/docs/authentication})}

\item{root_url}{String. Root url for your institution (see: \url{https://api.qualtrics.com/docs/root-url})}

\item{verbose}{Logical. If TRUE, verbose messages will be printed to the R console. Defaults to TRUE.}

\item{useLabels}{Logical. TRUE to export survey responses as Choice Text or FALSE to export survey responses as values.}

\item{convertStandardColumns}{Logical. If TRUE, then the \code{\link[qualtRics]{getSurvey}} function will convert general data columns (first name, last name, lat, lon, ip address, startdate, enddate etc.) to their proper format. Defaults to TRUE.}

\item{useLocalTime}{Logical. Use local timezone to determine response date values? Defaults to FALSE. See \url{https://api.qualtrics.com/docs/dates-and-times} for more information.}

\item{dateWarning}{Logical. Once per session, qualtRics will emit a warning about date conversion for surveys. You can turn this warning off by changing the flag to FALSE. Defaults to TRUE.}
}
\description{
Prints an example of a qualtRics configuration file to the console.
}
\examples{
\dontrun{
# Execute this line to get instructions on how to make a .qualtrics.yml config file.
qualtRicsConfigFile()
}

}
\seealso{
See \url{https://api.qualtrics.com/docs/root-url} for documentation on the Qualtrics API. See \url{https://github.com/JasperHG90/qualtRics/blob/master/README.md#using-a-configuration-file} for more information about the qualtRics configuration file.
}
\author{
Jasper Ginn
}
