% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qm_is_cluster.R
\name{qm_is_cluster}
\alias{qm_is_cluster}
\title{Validate cluster object}
\usage{
qm_is_cluster(obj, verbose = FALSE)
}
\arguments{
\item{obj}{Object to test}

\item{verbose}{A logical scalar; if \code{TRUE}, a tibble with test results is returned}
}
\value{
A logical scalar that is \code{TRUE} if the given object contains the approprite
  characteristics; if it does not, \code{FALSE} is returned.
}
\description{
This function tests to see whether an object contains the characteristics of an object
  created by \code{qm_cluster}. It is used as part of the \code{qm_combine} and \code{qm_summarize}
  functions, and is exported so that it can be used interactively as well.
}
\examples{
# load and format reference data
stl <- stLouis
stl <- dplyr::mutate(stl, TRACTCE = as.numeric(TRACTCE))

# create cluster
cluster <- qm_define(118600, 119101, 119300)

# create simple cluster object
cluster_obj <- qm_create(ref = stl, key = TRACTCE, value = cluster,
    rid = 1, cid = 1, category = "positive")

# test cluster object
qm_is_cluster(cluster_obj)
qm_is_cluster(cluster_obj, verbose = TRUE)

}
\seealso{
\code{qm_combine}, \code{qm_summarize}
}
