% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{maps6x}
\alias{maps6x}
\title{Simulated autohexaploid map}
\format{
An object of class \code{"mappoly.map"} from the package \pkg{mappoly}, which is a list of three linkage groups (LGs):

\describe{
  \item{LG 1}{538 markers distributed along 112.2 cM}
  \item{LG 2}{329 markers distributed along 54.6 cM}
  \item{LG 3}{443 markers distributed along 98.2 cM}
}
}
\usage{
maps6x
}
\description{
A simulated map containing three homology groups of a hypotetical cross between two autohexaploid individuals.
}
\examples{
library(mappoly)
plot_map_list(maps6x)
}
\references{
Pereira GS, Gemenet DC, Mollinari M, Olukolu BA, Wood JC, Mosquera V, Gruneberg WJ, Khan A, Buell CR, Yencho GC, Zeng ZB (2019) Multiple QTL mapping in autopolyploids: a random-effect model approach with application in a hexaploid sweetpotato full-sib population, \emph{Genetics} 215 (3): 579-595. \doi{10.1534/genetics.120.303080}.

    Mollinari M, Garcia AAF (2019) Linkage analysis and haplotype phasing in experimental autopolyploid populations with high ploidy level using hidden Markov models, \emph{G3: Genes|Genomes|Genetics} 9 (10): 3297-3314. \doi{10.1534/g3.119.400378}
}
\seealso{
\code{\link[mappoly]{hexafake}}, \code{\link[qtlpoly]{pheno6x}}
}
\author{
Marcelo Mollinari, \email{mmollin@ncsu.edu}
}
\keyword{datasets}
