% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_data.R
\name{read_data}
\alias{read_data}
\alias{print.qtlpoly.data}
\title{Read genotypic and phenotypic data}
\usage{
read_data(
  ploidy = 6,
  geno.prob,
  geno.dose = NULL,
  double.reduction = FALSE,
  pheno,
  weights = NULL,
  step = 1,
  verbose = TRUE
)

\method{print}{qtlpoly.data}(x, detailed = FALSE, ...)
}
\arguments{
\item{ploidy}{a numeric value of ploidy level of the cross.}

\item{geno.prob}{an object of class \code{mappoly.genoprob} from \pkg{mappoly}.}

\item{geno.dose}{an object of class \code{mappoly.data} from \pkg{mappoly}.}

\item{double.reduction}{if \code{TRUE}, double reduction genotypes are taken into account; if \code{FALSE}, no double reduction genotypes are considered.}

\item{pheno}{a data frame of phenotypes (columns) with individual names (rows) identical to individual names in \code{geno.prob} and/or \code{geno.dose} object.}

\item{weights}{a data frame of phenotype weights (columns) with individual names (rows) identical to individual names in \code{pheno} object.}

\item{step}{a numeric value of step size (in centiMorgans) where tests will be performed, e.g. 1 (default); if \code{NULL}, tests will be performed at every marker.}

\item{verbose}{if \code{TRUE} (default), current progress is shown; if \code{FALSE}, no output is produced.}

\item{x}{an object of class \code{qtlpoly.data} to be printed.}

\item{detailed}{if \code{TRUE}, detailed information on linkage groups and phenotypes in shown; if \code{FALSE}, no details are printed.}

\item{...}{currently ignored}
}
\value{
An object of class \code{qtlpoly.data} which is a list containing the following components:

    \item{ploidy}{a scalar with ploidy level.}
    \item{nlgs}{a scalar with the number of linkage groups.}
    \item{nind}{a scalar with the number of individuals.}
    \item{nmrk}{a scalar with the number of marker positions.}
    \item{nphe}{a scalar with the number of phenotypes.}
    \item{lgs.size}{a vector with linkage group sizes.}
    \item{cum.size}{a vector with cumulative linkage group sizes.}
    \item{lgs.nmrk}{a vector with number of marker positions per linkage group.}
    \item{cum.nmrk}{a vector with cumulative number of marker positions per linkage group.}
    \item{lgs}{a list with selected marker positions per linkage group.}
    \item{lgs.all}{a list with all marker positions per linkage group.}
    \item{step}{a scalar with the step size.}
    \item{pheno}{a data frame with phenotypes.}
    \item{G}{a list of relationship matrices for each marker position.}
    \item{Z}{a list of conditional probability matrices for each marker position for genotypes.}
    \item{X}{a list of conditional probability matrices for each marker position for alleles.}
    \item{Pi}{a matrix of identical-by-descent shared alleles among genotypes.}
}
\description{
Reads files in specific formats and creates a \code{qtlpoly.data} object to be used in subsequent analyses.
}
\examples{
  \donttest{
  # Estimate conditional probabilities using mappoly package
  library(mappoly)
  library(qtlpoly)
  genoprob4x = lapply(maps4x[c(5)], calc_genoprob)
  data = read_data(ploidy = 4, geno.prob = genoprob4x, pheno = pheno4x, step = 1)
  }
}
\references{
Pereira GS, Gemenet DC, Mollinari M, Olukolu BA, Wood JC, Mosquera V, Gruneberg WJ, Khan A, Buell CR, Yencho GC, Zeng ZB (2020) Multiple QTL mapping in autopolyploids: a random-effect model approach with application in a hexaploid sweetpotato full-sib population, \emph{Genetics} 215 (3): 579-595. \doi{10.1534/genetics.120.303080}.
}
\seealso{
\code{\link[qtlpoly]{maps6x}}, \code{\link[qtlpoly]{pheno6x}}
}
\author{
Guilherme da Silva Pereira, \email{gdasilv@ncsu.edu}
}
