% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iplot.R
\name{iplot}
\alias{iplot}
\title{Interactive scatterplot}
\usage{
iplot(x, y, group, indID, chartOpts = NULL)
}
\arguments{
\item{x}{Numeric vector of x values}

\item{y}{Numeric vector of y values}

\item{group}{Optional vector of categories for coloring the points}

\item{indID}{Optional vector of character strings, shown with tool tips}

\item{chartOpts}{A list of options for configuring the chart.  Each
element must be named using the corresponding option.}
}
\value{
An object of class \code{htmlwidget} that will
intelligently print itself into HTML in a variety of contexts
including the R console, within R Markdown documents, and within
Shiny output bindings.
}
\description{
Creates an interactive scatterplot.
}
\examples{
x <- rnorm(100)
grp <- sample(1:3, 100, replace=TRUE)
y <- x*grp + rnorm(100)
\donttest{
iplot(x, y, grp)}

}
\seealso{
\code{\link{iplotCorr}}, \code{\link{iplotCurves}}
}
\keyword{hplot}

