% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/listof_scan1coef.R
\name{listof_scan1coef}
\alias{listof_scan1coef}
\alias{summary_listof_scan1coef}
\alias{summary.listof_scan1coef}
\alias{summary_scan1coef}
\alias{summary.scan1coef}
\alias{subset_listof_scan1coef}
\alias{subset.listof_scan1coef}
\alias{[.listof_scan1coef}
\title{List of scan1coef objects}
\usage{
listof_scan1coef(
  probs,
  phe,
  K = NULL,
  covar = NULL,
  blups = FALSE,
  center = FALSE,
  ...
)

summary_listof_scan1coef(
  object,
  scan1_object,
  map,
  coef_names = dimnames(object[[1]])[[2]],
  center = TRUE,
  ...
)

\method{summary}{listof_scan1coef}(object, ...)

summary_scan1coef(object, scan1_object, map, ...)

\method{summary}{scan1coef}(object, ...)

subset_listof_scan1coef(x, elements, ...)

\method{subset}{listof_scan1coef}(x, ...)

\method{[}{listof_scan1coef}(x, ...)
}
\arguments{
\item{probs}{genotype probabilities object for one chromosome from \code{\link[qtl2]{calc_genoprob}}}

\item{phe}{data frame of phenotypes}

\item{K}{list of length 1 with kinship matrix}

\item{covar}{matrix of covariates}

\item{blups}{Create BLUPs if \code{TRUE}}

\item{center}{center coefficients if \code{TRUE}}

\item{...}{ignored}

\item{object}{object of class \code{listof_scan1coef}}

\item{scan1_object}{object from \code{scan1}}

\item{map}{A list of vectors of marker positions, as produced by
\code{\link[qtl2]{insert_pseudomarkers}}.}

\item{coef_names}{names of effect coefficients (default is all coefficient names)}

\item{x}{object of class \code{listof_scan1coef}}

\item{elements}{indexes or names of list elements in x}
}
\value{
object of class \code{listof_scan1coef}
}
\description{
Create a list of scan1coef objects using \code{\link[qtl2]{scan1coef}}.

Summary of object of class \code{\link{listof_scan1coef}}, which is a list of objects of class \code{scan1coef}.

Summary of object of class \code{\link{listof_scan1coef}}, which is a list of objects of class \code{scan1coef}.

Subset of object of class \code{\link{listof_scan1coef}}, which is a list of objects of class \code{scan1coef}.
}
\examples{
# read data
iron <- qtl2::read_cross2(system.file("extdata", "iron.zip", package="qtl2"))

# insert pseudomarkers into map
map <- qtl2::insert_pseudomarkers(iron$gmap, step=1)

# calculate genotype probabilities
probs <- qtl2::calc_genoprob(iron, map, error_prob=0.002)

# Ensure that covariates have names attribute
covar <- match(iron$covar$sex, c("f", "m")) # make numeric
names(covar) <- rownames(iron$covar)

# Calculate scan1coef on all phenotypes,
# returning a list of \code{\link{scan1coef}} objects
out <- listof_scan1coef(probs[,7], iron$pheno, addcovar = covar, center = TRUE)

# Plot coefficients for all phenotypes
ggplot2::autoplot(out, map[7], columns = 1:3)

# Summary of coefficients at scan peak
scan_pr <- qtl2::scan1(probs[,7], iron$pheno)
summary(out, scan_pr, map[7])

}
\author{
Brian S Yandell, \email{brian.yandell@wisc.edu}

Brian S Yandell, \email{brian.yandell@wisc.edu}

Brian S Yandell, \email{brian.yandell@wisc.edu}

Brian S Yandell, \email{brian.yandell@wisc.edu}
}
\keyword{utilities}
