% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write2csv.R
\name{write2csv}
\alias{write2csv}
\title{Write a data frame to a CSV file}
\usage{
write2csv(
  df,
  filename,
  comment = "",
  sep = ",",
  comment.char = "#",
  row.names = NULL,
  overwrite = FALSE
)
}
\arguments{
\item{df}{A data frame (or matrix)}

\item{filename}{File name to write}

\item{comment}{Comment to place on the first line}

\item{sep}{Field separator}

\item{comment.char}{Character to use to initiate the comment lines}

\item{row.names}{If NA or NULL (the default), row names are not
included in the output file. Otherwise, the row names are
included as the first column of the output, and this is taken
to be the name for that column.}

\item{overwrite}{If TRUE, overwrite file if it exists. If FALSE
(the default) and the file exists, stop with an error.}
}
\value{
None.
}
\description{
Write a data frame to a CSV file in a special form, with info about the number of rows and columns.
}
\details{
If the file already exists, the function will refuse to write over it.

The file will include comments at the top, using \verb{#} as a
comment character, including the number of rows (not including the
header) and the number of columns.

By default, row names are not included. But with the option
\code{row.names} provided as a character string, they are added as an
initial column, with the value of this argument defining the name
for that column. If a column with that name already exists, the
function halts with an error.
}
\examples{
nr <- 10
nc <- 5
x <- data.frame(id=paste0("ind", 1:nr),
                matrix(rnorm(nr*nc), ncol=nc))
colnames(x)[1:nc + 1] <- paste0("col", 1:nc)

testfile <- file.path(tempdir(), "tmpfile.csv")
write2csv(x, testfile, "A file created by write2csv")

# Remove the file, to clean up temporary directory
unlink(testfile)
}
