% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/encode_geno.R
\name{encode_geno}
\alias{encode_geno}
\title{Encode a matrix of genotypes using a set of allele codes}
\usage{
encode_geno(
  geno,
  allele_codes,
  output_codes = c("-", "A", "H", "B"),
  cores = 1
)
}
\arguments{
\item{geno}{Character matrix of genotypes (rows as markers, columns as individuals)}

\item{allele_codes}{Two-column matrix of alleles (rows as markers)}

\item{output_codes}{Vector of length four, with missing, AA, AB, BB codes}

\item{cores}{Number of CPU cores to use, for parallel calculations.
(If \code{0}, use \code{\link[parallel:detectCores]{parallel::detectCores()}}.)
Alternatively, this can be links to a set of cluster sockets, as
produced by \code{\link[parallel:makeCluster]{parallel::makeCluster()}}.}
}
\value{
Matrix of same dimensions as \code{geno}, but with values in \code{output_codes}.
}
\description{
Encode a matrix of genotypes using a set of allele codes.
}
\examples{
geno <- rbind(c("C", "G", "C",  "GG", "CG"),
              c("A", "A", "AT", "TA", "TT"),
              c("T", "G", NA,   "GT", "TT"))
codes <- rbind(c("C", "G"), c("A", "T"), c("T", "G"))
geno_encoded <- encode_geno(geno, codes)

}
\seealso{
\code{\link[=find_consensus_geno]{find_consensus_geno()}}, \code{\link[=find_unique_geno]{find_unique_geno()}}
}
