% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zip_datafiles.R
\name{zip_datafiles}
\alias{zip_datafiles}
\title{Zip a set of data files}
\usage{
zip_datafiles(control_file, zip_file = NULL, overwrite = FALSE, quiet = TRUE)
}
\arguments{
\item{control_file}{Character string with path to the control file
(\href{https://yaml.org}{YAML} or \href{https://json.org}{JSON})
containing all of the control information.}

\item{zip_file}{Name of zip file to use. If NULL, we use the
stem of \code{control_file} but with a \code{.zip} extension.}

\item{overwrite}{If \code{TRUE}, overwrite file if it exists. If \code{FALSE}
(the default) and the file exists, stop with an error.}

\item{quiet}{If \code{FALSE}, print progress messages.}
}
\value{
Character string with the file name of the zip file that
was created.
}
\description{
Zip a set of data files (in format read by \code{\link[=read_cross2]{read_cross2()}}).
}
\details{
The input \code{control_file} is the control file (in
\href{https://yaml.org}{YAML} or \href{https://json.org}{JSON} format)
to be read by \code{\link[=read_cross2]{read_cross2()}}.  (See the
\href{https://kbroman.org/qtl2/pages/sampledata.html}{sample data files} and the
\href{https://kbroman.org/qtl2/assets/vignettes/input_files.html}{vignette describing the input file format}.)

The \code{\link[utils:zip]{utils::zip()}} function is used to do the zipping.

The files should all be contained within the directory where the
\code{control_file} sits, or in a subdirectory of that directory.
If file paths use \code{..}, these get stripped by zip, and so the
resulting zip file may not work with \code{\link[=read_cross2]{read_cross2()}}.
}
\examples{
\dontrun{
zipfile <- file.path(tempdir(), "grav2.zip")
zip_datafiles("grav2.yaml", zipfile)
}
}
\seealso{
\code{\link[=read_cross2]{read_cross2()}}, sample data files at \url{https://kbroman.org/qtl2/pages/sampledata.html}
}
\keyword{IO}
