% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_entropy.R
\name{calc_entropy}
\alias{calc_entropy}
\title{Calculate entropy of genotype probability distribution}
\usage{
calc_entropy(probs, quiet = TRUE, cores = 1)
}
\arguments{
\item{probs}{Genotype probabilities, as calculated from
\code{\link[=calc_genoprob]{calc_genoprob()}}.}

\item{quiet}{IF \code{FALSE}, print progress messages.}

\item{cores}{Number of CPU cores to use, for parallel calculations.
(If \code{0}, use \code{\link[parallel:detectCores]{parallel::detectCores()}}.)
Alternatively, this can be links to a set of cluster sockets, as
produced by \code{\link[parallel:makeCluster]{parallel::makeCluster()}}.}
}
\value{
A list of matrices (each matrix is a chromosome and is arranged as individuals x markers).
}
\description{
For each individual at each genomic position, calculate the entropy
of the genotype probability distribution, as a quantitative summary
of the amount of missing information.
}
\details{
We calculate -sum(p log_2 p), where we take 0 log 0 = 0.
}
\examples{
grav2 <- read_cross2(system.file("extdata", "grav2.zip", package="qtl2"))
\dontshow{grav2 <- grav2[,c(4,5)] # subset to chr 3}
probs <- calc_genoprob(grav2, error_prob=0.002)
e <- calc_entropy(probs)
e <- do.call("cbind", e) # combine chromosomes into one big matrix

# summarize by individual
mean_ind <- rowMeans(e)

# summarize by marker
mean_marker <- colMeans(e)
}
\keyword{utilities}
