% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interp_genoprob.R
\name{interp_genoprob}
\alias{interp_genoprob}
\title{Interpolate genotype probabilities}
\usage{
interp_genoprob(probs, map, cores = 1)
}
\arguments{
\item{probs}{Genotype probabilities, as calculated from
\code{\link[=calc_genoprob]{calc_genoprob()}}.}

\item{map}{List of vectors of map positions.}

\item{cores}{Number of CPU cores to use, for parallel calculations.
(If \code{0}, use \code{\link[parallel:detectCores]{parallel::detectCores()}}.)
Alternatively, this can be links to a set of cluster sockets, as
produced by \code{\link[parallel:makeCluster]{parallel::makeCluster()}}.}
}
\value{
An object of class \code{"calc_genoprob"}, like the input,
but with additional positions present in \code{map}. See \code{\link[=calc_genoprob]{calc_genoprob()}}.
}
\description{
Linear interpolation of genotype probabilities, mostly to get two sets onto the same map for comparison purposes.
}
\details{
We reduce \code{probs} to the positions present in \code{map} and then
interpolate the genotype probabilities at additional positions
in \code{map} by linear interpolation using the two adjacent
positions. Off the ends, we just copy over the first or last
value unchanged.

In general, it's better to use \code{\link[=insert_pseudomarkers]{insert_pseudomarkers()}} and
\code{\link[=calc_genoprob]{calc_genoprob()}} to get genotype probabilities at additional
positions along a chromosome. This function is a \strong{very} crude
alternative that was implemented in order to compare genotype
probabilities derived by different methods, where we first need to
get them onto a common set of positions.
}
\examples{
iron <- read_cross2(system.file("extdata", "iron.zip", package="qtl2"))
\dontshow{iron <- iron[1:20,c("1", "X")]}
probs <- calc_genoprob(iron, iron$gmap, error_prob=0.002)

# you generally wouldn't want to do this, but this is an illustration
map <- insert_pseudomarkers(iron$gmap, step=1)
probs_map <- interp_genoprob(probs, map)

}
\seealso{
\code{\link[=calc_genoprob]{calc_genoprob()}}
}
